% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print.haldensify}
\alias{print.haldensify}
\title{Print: Highly Adaptive Lasso Conditional Density Estimates}
\usage{
\method{print}{haldensify}(x, ...)
}
\arguments{
\item{x}{An object of class \code{haldensify}.}

\item{...}{Other options (not currently used).}
}
\value{
None. Called for the side effect of printing an informative summary
 of slots of objects of class \code{haldensify}.
}
\description{
Print: Highly Adaptive Lasso Conditional Density Estimates
}
\details{
The \code{print} method for objects of class \code{haldensify}
}
\examples{
# simulate data: W ~ U[-4, 4] and A|W ~ N(mu = W, sd = 0.5)
set.seed(429153)
n_train <- 50
w <- runif(n_train, -4, 4)
a <- rnorm(n_train, w, 0.5)

# learn relationship A|W using HAL-based density estimation procedure
haldensify_fit <- haldensify(
  A = a, W = w, n_bins = c(3, 5),
  lambda_seq = exp(seq(-1, -15, length = 50L)),
  max_degree = 3, reduce_basis = 0.1
)
print(haldensify_fit)
}
