% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{templateK40}
\alias{templateK40}
\title{Cluster Template with 40 Clusters}
\format{
A list containing the contents of the cluster template.
\describe{
\item{cluster}{A vector of cluster assignments
for each graph used to create the cluster template. The clusters are numbered sequentially 1, 2,...,40.}
\item{centers}{The final cluster centers produced by the K-Means algorithm.}
\item{K}{The number of clusters in the template (40).}
\item{n}{The number of training graphs to used to create the template (32,708).}
\item{wcd}{The within cluster
distances, the distance between each graph and the nearest cluster center, on the final iteration of the K-means algorithm.}
}
}
\usage{
templateK40
}
\description{
A cluster template created by \pkg{handwriter} with 40 clusters. This
template was created from 100 handwriting samples from the CSAFE Handwriting
Database, the CVL Handwriting Database, and the IAM Handwriting Database.
}
\details{
\pkg{handwriter} splits handwriting samples into component shapes called
graphs. The graphs are sorted into 40 clusters with a K-Means algorithm.
}
\examples{
handwriter::plot_cluster_centers(templateK40)

}
\keyword{cluster}
