% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhcartr_run_classifier.R
\name{hhcart_run_classifier}
\alias{hhcart_run_classifier}
\title{hhcart_run_classifier - This function calls grow_tree_() to induce a decision tree.}
\usage{
hhcart_run_classifier(
  train_set,
  sample_size,
  j,
  n_min,
  min_node_impurity,
  sampleWithReplacement,
  useIdentity,
  classify,
  n_features,
  n_classes,
  max_features = NA
)
}
\arguments{
\item{train_set}{The training data.}

\item{sample_size}{The sample size parameter is used to determine how much of the training
dataset is actually used during training. A value of 1.0 allows all of the current training
dataset to be used for training. A value of less than one will mean that proportion of the
training dataset will be selected at random and then used for training. The value of parameter
sampleWithReplacement will determine if the random sampling of the training dataset is
performed using replacement or not. The default value is 1.0.}

\item{j}{Not used, kept for compatibility.}

\item{n_min}{The n_min parameter is used to stop splitting a node when a
minimum number of samples at that node has been reached. The default value is 2.}

\item{min_node_impurity}{The min node impurity parameter is used to stop splitting a node
if the node impurity at that node is less than this value. The node impurity is calculated
using the hyperplane Gini index. The default value is 0.2.}

\item{sampleWithReplacement}{The sampleWithReplacement parameter is used in conjunction with
the sample size parameter. The sampleWithReplacement parameter will determine if sampling from
the training dataset is done with or without replacement. The default value is FALSE.}

\item{useIdentity}{The useIdentity parameter when set TRUE will result in hhcartr using the
original training data to find the optimal splits rather than using the reflected data. The
default value is FALSE.}

\item{classify}{The classify parameter when set TRUE indicates that the data is for building
a classification model. A value of FALSE and a regression model will be induced.}

\item{n_features}{The number of features in the training data.}

\item{n_classes}{The number of classes in the training data.}

\item{max_features}{The max features parameter determines the number of features to consider
when looking for the best split, and can take one of the values listed below. The default value
is “sqrt”.}
}
\value{
Returns an induced decision tree.
}
\description{
hhcart_run_classifier - This function calls grow_tree_() to induce a decision tree.
}
