#' Run chosen pre-built model in Stan
#'
#' @param model_template model template generated by hmde_model and updated by hmde_assign_data
#' @param ... additional arguments passed to rstan::sampling
#'
#' @return Stanfit model output
#'
#' @examples
#' # basic usage of hmde_run
#' hmde_model("constant_single_ind") |>
#'   hmde_assign_data(Trout_Size_Data)|>
#'   hmde_run(chains = 1, iter = 1000,
#'            verbose = FALSE, show_messages = FALSE)
#'
#' @export

hmde_run <- function(model_template, ...) {
  #Check for model
  if(!model_template$model %in% hmde_model_names()){
    stop("Model name not recognised. Run hmde_model_names() to see available models.")
  }

  # Detect model
  out <- switch(model_template$model,
         constant_single_ind = rstan::sampling(stanmodels$constant_single_ind, data = model_template, ...),
         constant_multi_ind = rstan::sampling(stanmodels$constant_multi_ind, data = model_template, ...),
         canham_single_ind = rstan::sampling(stanmodels$canham_single_ind, data = model_template, ...),
         canham_multi_ind = rstan::sampling(stanmodels$canham_multi_ind, data = model_template, ...),
         vb_single_ind = rstan::sampling(stanmodels$vb_single_ind, data = model_template, ...),
         vb_multi_ind = rstan::sampling(stanmodels$vb_multi_ind, data = model_template, ...),
         affine_single_ind = rstan::sampling(stanmodels$affine_single_ind, data = model_template, ...))

  return(out)
}
