% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-body.R
\name{req_get_body_type}
\alias{req_get_body_type}
\alias{req_get_body}
\title{Get request body}
\usage{
req_get_body_type(req)

req_get_body(req, obfuscated = c("remove", "redact", "reveal"))
}
\arguments{
\item{req}{A httr2 \link{request} object.}

\item{obfuscated}{Form and JSON bodies can contain \link{obfuscated} values.
This argument control what happens to them: should they be removed,
redacted, or revealed.}
}
\description{
This pair of functions gives you sufficient information to capture the
body of a request, and recreate, if needed. httr2 currently supports
seven possible body types:
\itemize{
\item empty: no body.
\item raw: created by \code{\link[=req_body_raw]{req_body_raw()}} with a raw vector.
\item string: created by \code{\link[=req_body_raw]{req_body_raw()}} with a string.
\item file: created by \code{\link[=req_body_file]{req_body_file()}}.
\item json: created by \code{\link[=req_body_json]{req_body_json()}}/\code{\link[=req_body_json_modify]{req_body_json_modify()}}.
\item form: created by \code{\link[=req_body_form]{req_body_form()}}.
\item multipart: created by \code{\link[=req_body_multipart]{req_body_multipart()}}.
}
}
\examples{
req <- request(example_url())
req |> req_body_raw("abc") |> req_get_body_type()
req |> req_body_file(system.file("DESCRIPTION")) |> req_get_body_type()
req |> req_body_json(list(x = 1, y = 2)) |> req_get_body_type()
req |> req_body_form(x = 1, y = 2) |> req_get_body_type()
req |> req_body_multipart(x = "x", y = "y") |> req_get_body_type()
}
