% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick-functions.R
\name{quick-output}
\alias{quick-output}
\alias{quick_latex}
\alias{quick_pdf}
\alias{quick_typst}
\alias{quick_typst_pdf}
\alias{quick_typst_png}
\alias{quick_typst_svg}
\alias{quick_html}
\alias{quick_docx}
\alias{quick_pptx}
\alias{quick_xlsx}
\alias{quick_rtf}
\title{Quickly print objects to a PDF, TeX, Typst, HTML, Microsoft Office or RTF document,
or PNG or SVG images}
\usage{
quick_latex(
  ...,
  file = confirm("huxtable-output.tex"),
  borders = 0.4,
  open = interactive()
)

quick_pdf(
  ...,
  file = confirm("huxtable-output.pdf"),
  borders = 0.4,
  open = interactive(),
  width = NULL,
  height = NULL
)

quick_typst(
  ...,
  file = confirm("huxtable-output.typ"),
  borders = 0.4,
  open = interactive()
)

quick_typst_pdf(
  ...,
  file = confirm("huxtable-output.pdf"),
  borders = 0.4,
  open = interactive(),
  width = NULL,
  height = NULL
)

quick_typst_png(
  ...,
  file = confirm_prefix("huxtable-output"),
  borders = 0.4,
  open = interactive(),
  width = NULL,
  height = NULL,
  ppi = NULL
)

quick_typst_svg(
  ...,
  file = confirm_prefix("huxtable-output"),
  borders = 0.4,
  open = interactive(),
  width = NULL,
  height = NULL
)

quick_html(
  ...,
  file = confirm("huxtable-output.html"),
  borders = 0.4,
  open = interactive()
)

quick_docx(
  ...,
  file = confirm("huxtable-output.docx"),
  borders = 0.4,
  open = interactive()
)

quick_pptx(
  ...,
  file = confirm("huxtable-output.pptx"),
  borders = 0.4,
  open = interactive()
)

quick_xlsx(
  ...,
  file = confirm("huxtable-output.xlsx"),
  borders = 0.4,
  open = interactive()
)

quick_rtf(
  ...,
  file = confirm("huxtable-output.rtf"),
  borders = 0.4,
  open = interactive()
)
}
\arguments{
\item{...}{One or more huxtables or R objects with an \code{as_huxtable} method.}

\item{file}{File path for the output.}

\item{borders}{Border width for members of \code{...} that are not huxtables.}

\item{open}{Logical. Automatically open the resulting file?}

\item{width}{String passed to the LaTeX \code{geometry} package's \code{paperwidth} option or Typst's \code{page}
\code{width} option. Use \code{NULL} for the default width.}

\item{height}{String passed to the LaTeX \code{geometry} package's \code{paperheight} option or Typst's
\code{page} \code{height} option. Use \code{NULL} for the default height.}

\item{ppi}{Pixels per inch for PNG output.}
}
\value{
Invisible \code{NULL}.
}
\description{
These functions use huxtable to print objects to an output document. They are useful
as one-liners for data reporting.
}
\details{
Objects in \code{...} will be converted to huxtables, with borders added.

If \sQuote{file} is not specified, the command will fail in non-interactive sessions. In
interactive sessions, the default file path is "huxtable-output.xxx" in the working directory;
if this already exists, you will be asked to confirm manually before proceeding.

To create docx and pptx files \code{flextable} and \code{officer} must be installed, while xlsx
needs \code{openxlsx}. \code{quick_typst_pdf()}, \code{quick_typst_png()}, and \code{quick_typst_svg()} require the \code{typst}
command line tool.

\code{quick_typst_pdf()} with e.g. \code{file = "foo.pdf"} will overwrite and delete
the file \code{foo.typ}.

\code{quick_typst_png()} and \code{quick_typst_svg()} create one image per huxtable. If there is more than
one object in \code{...}, images will have a numeric suffix like \verb{"-1", "-2"} etc.
Existing files with the same \code{file} prefix will be overwritten after
confirmation in interactive sessions.
}
\examples{
\dontrun{
m <- matrix(1:4, 2, 2)

quick_pdf(m, jams)
quick_latex(m, jams)
quick_typst(m, jams)
quick_typst_pdf(m, jams)
quick_typst_png(m, jams)
quick_typst_svg(m, jams)
quick_html(m, jams)
quick_docx(m, jams)
quick_xlsx(m, jams)
quick_pptx(m, jams)
quick_rtf(m, jams)
}
}
