% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvSieve.R
\name{mvSieve}
\alias{mvSieve}
\title{Sieve of amount of missing values in a time series of satellite images}
\usage{
mvSieve(dirs, filesPerDir, startPeriod, endPeriod, colNames = month.name)
}
\arguments{
\item{dirs}{character vector given sub-directory names from which images will be read.}

\item{filesPerDir}{numeric indicating how many images are stored in each directory.}

\item{startPeriod}{numeric indicating in which period the time series first image was recorded.}

\item{endPeriod}{numeric indicating in which period the time series last image was recorded.}

\item{colNames}{character vector. Default \code{month.name} which assumes that \code{filesPerDir=12}.}
}
\value{
An \eqn{n \times m} matrix where \eqn{n} is equal to \code{length(dirs)} and \eqn{m} is equal to
\code{filesPerDir}. By default, the row names of this matrix are equal to \code{startPeriod:endPeriod}
and the column names are equal to \code{colNames}.
}
\description{
This function computes the number of pixels with missing values (no data) in each element
of a time series of satellite images. For practical purposes, this function assumes that
the images have been stored in a set of different sub-directories; each sub-directory can
represent a period/season/year.
}
\seealso{
\code{\link[igapfill]{minmaxBlock}}
}
