% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSquadMatchScores.R
\name{getSquadMatchScores}
\alias{getSquadMatchScores}
\title{Return a dataframe that contains squad level scores and ratios for a given match ID}
\usage{
getSquadMatchScores(matches, token)
}
\arguments{
\item{matches}{'IMPECT' match IDs}

\item{token}{bearer token}
}
\value{
a dataframe containing the scores and rations aggregated per squad for the given match ID
}
\description{
Return a dataframe that contains squad level scores and ratios for a given match ID
}
\examples{
# Toy example: this will error quickly (no API token)
try(squad_match_scores <- getSquadMatchScores(
  matches = c(0, 1),
  token = "invalid"
))

# Real usage: requires valid Bearer Token from `getAccessToken()`
\dontrun{
squad_match_scores <- getSquadMatchScores(
  matches = c(84248, 158150),
  token = "yourToken"
)
}
}
