% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subjectProfileSummaryPlot.R
\name{subjectProfileSummaryTable}
\alias{subjectProfileSummaryTable}
\title{Plot a table with \code{ggplot} of a text variable of interest.}
\usage{
subjectProfileSummaryTable(
  data,
  xVar,
  text,
  xLim = NULL,
  colorVar = NULL,
  colorPalette = NULL,
  colorLab = getLabelVar(colorVar, labelVars = labelVars),
  fontface = 1,
  xLab = NULL,
  labelVars = NULL,
  caption = NULL,
  showLegend = TRUE,
  legendPosition = ifelse(showLegend, "right", "none"),
  yAxisLabs = FALSE,
  xAxisLabs = NULL,
  style = "report",
  fontname = switch(style, report = "Times", presentation = "Tahoma"),
  fontsize = switch(style, report = 8, presentation = 10),
  pointSize = 1.5,
  themeFct = switch(style, report = theme_classic, presentation = theme_bw),
  textSize = fontsize/ggplot2::.pt,
  xTrans = NULL
)
}
\arguments{
\item{data}{Data.frame (in long format) with data for the table.}

\item{xVar}{String, variable of \code{data} with variable for the x-axis.}

\item{text}{Character vector with colnames of \code{data}
or expression based on colnames of \code{data} to extract
the text label.}

\item{xLim}{Vector of the length 2 with limits for the x-axis.}

\item{colorVar}{String, variable of \code{data} for coloring.}

\item{colorPalette}{(named) Vector with color palette.}

\item{colorLab}{String, label for \code{colorVar}, used in the legend.}

\item{fontface}{Numeric, fontface for the text.}

\item{xLab}{String with label for the x-axis.}

\item{labelVars}{Named string with variable labels (names are the variable code).}

\item{caption}{String with caption for the plot,
NULL by default.}

\item{showLegend}{Logical, should the legend be displayed? TRUE by default.}

\item{legendPosition}{String with legendPosition,
'right' by default.}

\item{yAxisLabs}{Logical, if TRUE include the labels in the y-axis.}

\item{xAxisLabs}{Vector with labels for the x-axis if \code{xVar}
is discrete or vector with limits if continuous.}

\item{style}{String with subject profile style.
This affects the parameters: \code{fontname}, \code{fontsize}
and \code{themeFct}.}

\item{fontname}{String with font name,
by default 'Times' if \code{style} is 'report' and
'Tahoma' if \code{style} is 'presentation'.}

\item{fontsize}{Numeric vector of length 1 with font size,
by default 8 if \code{style} is 'report' and
10 if \code{style} is 'presentation'}

\item{pointSize}{Numeric indicating the size of points in the legend, 1.5 by default}

\item{themeFct}{Function with ggplot2 theme,
by default \code{\link[ggplot2]{theme_classic}} if \code{style} is 'report' and
\code{\link[ggplot2]{theme_bw}} if \code{style} is 'presentation'.}

\item{textSize}{Size for the text.}

\item{xTrans}{(optional) ggplot2 transformation
for the x-axis.}
}
\value{
\code{\link[ggplot2]{ggplot}} object
}
\description{
The labels extracted based on the \code{text} parameter 
and displayed at the x-position based on \code{xVar} and the y-position based on
\code{colorVar}.
Each group specified in the color variables are displayed in different
lines in the plot.
}
\author{
Laure Cougnaud and Michela Pasetto
}
