% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper_factor}
\alias{bru_mapper_factor}
\alias{ibm_n.bru_mapper_factor}
\alias{ibm_values.bru_mapper_factor}
\alias{ibm_jacobian.bru_mapper_factor}
\title{Mapper for factor variables}
\usage{
bru_mapper_factor(values, factor_mapping, indexed = FALSE)

\method{ibm_n}{bru_mapper_factor}(mapper, ...)

\method{ibm_values}{bru_mapper_factor}(mapper, ...)

\method{ibm_jacobian}{bru_mapper_factor}(mapper, input, ...)
}
\arguments{
\item{values}{Input values calculated by \code{\link[=input_eval.bru_input]{input_eval.bru_input()}}}

\item{factor_mapping}{character; selects the type of factor mapping.
\itemize{
\item \code{'contrast'} for leaving out the first factor level.
\item \code{'full'} for keeping all levels.
}}

\item{indexed}{logical; if \code{TRUE}, the \code{ibm_values()} method
will return an integer vector instead of the factor levels.
This is needed e.g. for \code{group} and \code{replicate} mappers, since
\code{INLA::f()} doesn't accept factor values. Default: \code{FALSE}, which
works for the main input mappers. The default mapper constructions
will set it the required setting.}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{...}{Arguments passed on to other methods}

\item{input}{Data input for the mapper.}
}
\description{
Create a factor mapper
}
\examples{
m <- bru_mapper_factor(factor(c("a", "b")), "full")
ibm_eval2(m, input = c("b", "a", "a", "b"), state = c(1, 3))

m <- bru_mapper_factor(factor(c("a", "b")), "contrast")
ibm_eval2(m, input = factor(c("b", "a", "a", "b")), state = 2)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_fmesher}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_repeat}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()},
\code{\link{bru_mapper_taylor}()}
}
\concept{mappers}
