% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_newdata.R
\name{check_newdata}
\alias{check_newdata}
\title{Check new data}
\usage{
check_newdata(newdata, olddata, req_vars, exclude = FALSE)
}
\arguments{
\item{newdata}{A `data.frame` containing new data}

\item{olddata}{A `data.frame` containing existing data. `newdata` variable
classes will be required to match `olddata`}

\item{req_vars}{A `character` vector of required variable names that must
appear in `newdata`}

\item{exclude}{Logical: Whether a variable `"exclude"` also must be present in `newdata`}
}
\value{
`TRUE`, if required variables are present in `newdata`, and required
  variables are of the same class in `newdata` and `olddata`. Otherwise, this
  function will stop with an error.
}
\description{
Check new data to ensure it has the required variables and classes
}
\details{
This is a helper function to check new data to ensure it has the required
variables and that those variables are of the correct classes. This is
useful, for example, when making predictions from a fitted [pk()] model
object on new data.
}
\author{
Caroline Ring
}
