% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_excl_plot.R
\encoding{utf-8}
\name{ind_excl_plot}
\alias{ind_excl_plot}
\title{Plot indicator exlusion results with and without excluded indicators}
\usage{
ind_excl_plot(indicators, indicators2 = vector(), outcome,
  scalename = "scale", outcomename = "outcome",
  indicatornames = 1:ncol(indicators), tagged = vector(),
  tagged2 = vector(), location1 = "topleft", location2 = "topright",
  pcrit = 0.05, multi = 1, coruse = "everything", ci = "estimate")
}
\arguments{
\item{indicators}{Set of numeric indicators (items) in a matrix.}

\item{indicators2}{An additional set of indicators (e.g. informant-report )}

\item{outcome}{A numeric outcome vector. Indicators and outcome can be simulated with
\code{\link{scale_sim}}}

\item{scalename}{A string for labelling the scale}

\item{outcomename}{A string for labelling the outcome}

\item{indicatornames}{An array of strings for labelling the outcome. Default to numbers
from 1 to n of indicators}

\item{tagged}{items to be marked as excluded by the indicator exclusion procedure}

\item{tagged2}{same as 'tagged' for second scale (e.g., informant report)}

\item{location1}{Location for legends at left-side plot}

\item{location2}{Location for legends at right-side plot}

\item{pcrit}{a p-value characterising the ‘significance’ of difference between
correlations—here called ‘significance of indicator exclusion’ (SONE). Look it up
from Table 2 in Vainik, Mõttus et al 2015, or simulate using
 \code{\link{optimal_p}} function}

\item{multi}{influences cex of certain plot variables. Defaults to 1}

\item{coruse}{argument for function cor(). Defaults to 'everything', as
simulations have no missing data.}

\item{ci}{should output object and plot have 95% confidence intervals (CI-s). Defaults to
CI-s from  \code{\link[psych]{corr.test}}. If you insert a number (e.g., ci=5000), then the CI-s
are bootstrapped using \code{\link[psych]{cor.ci}}. Any other string results in no CI-s.
r value in output matrix is taken from \code{\link[stats]{cor}}.}
}
\value{
See \code{\link{ind_excl}}
}
\description{
Provides an overview of the indicator exclusion results. Marked(x) indicators are excluded in the indicator exclusion procedure. See \code{\link{ind_excl}} for details.
\describe{
  \item{left}{correlations between single indicator and outcome}
  \item{right}{correlations between sum-score and outcome with and without the marked indicators}
}
}

