% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{logistic_get_stats}
\alias{logistic_get_stats}
\title{Logistic Regression Gradient and Hessian}
\usage{
logistic_get_stats(
  est,
  X_l,
  Y_l,
  f_l,
  X_u,
  f_u,
  w_l = NULL,
  w_u = NULL,
  use_u = TRUE
)
}
\arguments{
\item{est}{(vector): Point estimates of the coefficients.}

\item{X_l}{(matrix): Covariates for the labeled data set.}

\item{Y_l}{(vector): Labels for the labeled data set.}

\item{f_l}{(vector): Predictions for the labeled data set.}

\item{X_u}{(matrix): Covariates for the unlabeled data set.}

\item{f_u}{(vector): Predictions for the unlabeled data set.}

\item{w_l}{(vector, optional): Sample weights for the labeled data set.}

\item{w_u}{(vector, optional): Sample weights for the unlabeled data set.}

\item{use_u}{(bool, optional): Whether to use the unlabeled data set.}
}
\value{
(list): A list containing the following:

\describe{
\item{grads}{(matrix): n x p matrix gradient of the loss function with
respect to the coefficients.}
\item{grads_hat}{(matrix): n x p matrix gradient of the loss function
with respect to the coefficients, evaluated using the labeled
predictions.}
\item{grads_hat_unlabeled}{(matrix): N x p matrix gradient of the loss
function with respect to the coefficients, evaluated using the unlabeled
predictions.}
\item{inv_hessian}{(matrix): p x p matrix inverse Hessian of the loss
function with respect to the coefficients.}
}
}
\description{
Computes the statistics needed for the logstic regression-based
prediction-powered inference.
}
\examples{

dat <- simdat(model = "logistic")

form <- Y - f ~ X1

X_l <- model.matrix(form, data = dat[dat$set == "labeled",])

Y_l <- dat[dat$set == "labeled", all.vars(form)[1]] |> matrix(ncol = 1)

f_l <- dat[dat$set == "labeled", all.vars(form)[2]] |> matrix(ncol = 1)

X_u <- model.matrix(form, data = dat[dat$set == "unlabeled",])

f_u <- dat[dat$set == "unlabeled", all.vars(form)[2]] |> matrix(ncol = 1)

est <- ppi_plusplus_logistic_est(X_l, Y_l, f_l, X_u, f_u)

stats <- logistic_get_stats(est, X_l, Y_l, f_l, X_u, f_u)

}
