% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jam-calc-density.R
\name{jamCalcDensity}
\alias{jamCalcDensity}
\title{Calculate scatter plot point density}
\usage{
jamCalcDensity(x, nbin, bandwidth = NULL, range.x)
}
\arguments{
\item{x}{\code{numeric} matrix with two columns representing x,y coordinates.}

\item{nbin}{\code{integer} number of bins to subdivide the scatterplot,
expanded to length 2 to accommodate x and y axis bins.}

\item{bandwidth}{\code{numeric} or \code{NULL} representing the bandwidth used
for point density determination.}

\item{range.x}{\code{numeric} vector length 2 representing the range of
values to consider for point density.}
}
\value{
\code{list} with elements used internally by \code{plotSmoothScatter()},
with: x1, x2, fhat, bandwidth.
}
\description{
Calculate scatter plot point density
}
\details{
This function is called internally by \code{plotSmoothScatter()},
and is an equivalent replacement for
\code{grDevices} non-exported function .smoothScatterCalcDensity(),
understandably a requirement by CRAN. A package should not rely
on another package hidden function.
}
\examples{
sdim(jamCalcDensity(cbind(x=rnorm(1000) + 4, y=rnorm(1000) + 4), nbin=30))

}
\seealso{
Other jam internal functions: 
\code{\link{handleArgsText}()},
\code{\link{make_html_styles}()},
\code{\link{make_styles}()},
\code{\link{smoothScatterJam}()}
}
\concept{jam internal functions}
