% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-plots.r
\name{plotSmoothScatter}
\alias{plotSmoothScatter}
\title{Smooth scatter plot with enhancements}
\usage{
plotSmoothScatter(
  x,
  y = NULL,
  bwpi = 50,
  binpi = 50,
  bandwidthN = NULL,
  nbin = NULL,
  expand = c(0.04, 0.04),
  transFactor = 0.25,
  transformation = function(x) x^transFactor,
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  nrpoints = 0,
  colramp = c("white", "lightblue", "blue", "orange", "orangered2"),
  col = "black",
  doTest = FALSE,
  fillBackground = TRUE,
  naAction = c("remove", "floor0", "floor1"),
  xaxt = "s",
  yaxt = "s",
  add = FALSE,
  asp = NULL,
  applyRangeCeiling = TRUE,
  useRaster = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{numeric vector, or data matrix with two or  more columns.}

\item{y}{numeric vector, or if data is supplied via x as a matrix, y
is NULL.}

\item{bwpi}{\code{numeric} value indicating the bandwidth "per inch"
to scale the bandwidth based upon visual space available.
This argument is used to define \code{bandwidthN}, however \code{bwpi}
is only used when \code{bandwidthN=NULL}.
The bandwidth is used to define the 2-dimensional point density.}

\item{binpi}{\code{numeric} value indicating the number of bins "per inch",
to scale based upon visual space available.
This argument is used to define \code{nbin}, however \code{binpi}
is only used when \code{nbin=NULL}.}

\item{bandwidthN}{\code{integer} number of bandwidth steps to use across the
visible plot window. Note that this bandwidth differs from default
\code{graphics::smoothScatter()} in that it uses the visible
plot window instead of the data range, so if the plot window is not
sufficiently similar to the data range, the resulting smoothed
density will not be visibly distorted. This parameter also permits
display of higher (or lower) level of detail.}

\item{nbin}{\code{integer} number of bins to use when converting the kernel
density result (which uses bandwidthN above) into a usable image.
This setting is effectively the resolution of rendering the
bandwidth density in terms of visible pixels. For example
\code{nbin=256} will create 256 visible pixels wide and tall in each
plot panel; and \code{nbin=32} will create 32 visible pixels, with
lower detail which may be suitable for multi-panel plots.
To use a variable number of bins, try \code{binpi}.}

\item{expand}{\code{numeric} value indicating the fraction of the x-axis
and y-axis ranges to add to create an expanded range,
used when \code{add=FALSE}. The default \code{expand=c(0.04, 0.04)} mimics
the R base plot default which adds 4 percent total, therefore 2 percent
to each side of the visible range.}

\item{transFactor}{\code{numeric} value used by the default \code{transformation}
function, which effectively scales the density of points to
a reasonable visible distribution. This argument is a convenience
method to avoid having to type out the full \code{transformation} function.}

\item{transformation}{\code{function} which converts point density to a number,
typically related to square root or cube root transformation. Note
that the default uses \code{transFactor} but if a custom function is
supplied, it will not use \code{transFactor} unless specified.}

\item{xlim}{\code{numeric} x-axis range, or \code{NULL} to use the data range.}

\item{ylim}{\code{numeric} y-axis range, or \code{NULL} to use the data range.}

\item{xlab, ylab}{\code{character} labels for x- and y-axis, respectively.}

\item{nrpoints}{\code{integer} number of outlier datapoints to display,
as defined by \code{graphics::smoothScatter()}, however the default here
is \code{nrpoints=0} to avoid additional clutter in the output,
and because the default arguments \code{bwpi}, \code{binpi} usually indicate all
individual points.}

\item{colramp}{any input recognized by \code{getColorRamp()}:
\itemize{
\item \code{character} vector with multiple colors
\item \code{character} string length 1, with valid R color used to create
a linear color gradient
\item \code{character} name of a known color gradient from \code{RColorBrewer}
or \code{viridis}
\item \code{function} that itself produces vector of colors,
in the form \verb{function(n)} where \code{n} defines the number of colors.
}}

\item{col}{\code{character} string with R color used when \code{nrpoints} is
non-zero, this color defines the color of those points.}

\item{doTest}{\code{logical} indicating whether to create a visual set of test
plots to demonstrate the utility of this function.}

\item{fillBackground}{\code{logical} indicating whether to fill the
background of the plot panel with the first color in \code{colramp}.
The default \code{fillBackground=TRUE} is useful since the plot panel
may be slightly wider than the range of data being displayed, and
when the first color in \code{colramp} is not the same as the plot device
background color.
Run a test using:
\code{plotSmoothScatter(doTest=TRUE, fillBackground=FALSE, colramp="viridis")}
and compare with:
\code{plotSmoothScatter(doTest=TRUE, colramp="viridis")}}

\item{naAction}{\code{character} string indicating how to handle NA values,
typically when x is NA and y is not NA, or vice versa. valid values:
\describe{
\item{"remove"}{ignore any points where either x or y are NA}
\item{"floor0"}{change any NA values to zero 0 for either x or y}
\item{"floor1"}{change any NA values to one 1 for either x or y}
}
The latter two options are useful when the desired plot should indicate
the presence of an NA value in either x or y, while also indicating the
the corresponding non-NA value in the opposing axis. The driving use
was plotting gene fold changes from two experiments, where the two
experiments may not have measured the same genes.}

\item{xaxt}{\code{character} value compatible with graphics::par(xaxt), used to control
the x-axis range, similar to its use in \code{plot()} generic functions.}

\item{yaxt}{\code{character} value compatible with graphics::par(yaxt), used to control
the y-axis range, similar to its use in \code{plot()} generic functions.}

\item{add}{\code{logical} whether to add to an existing active R plot, or create
a new plot window.}

\item{asp}{\code{numeric} with optional aspect ratio, as described in
\code{graphics::plot.window()}, where \code{asp=1} defines x- and y-axis
coordinate ranges such that distances between points are rendered
accurately. One data unit on the y-axis is equal in length to
\code{asp} multiplied by one data unit on the x-axis.
Notes:
\itemize{
\item When \code{add=TRUE}, the value \code{asp} is ignored, because
the existing plot device is re-used.
\item When \code{add=FALSE} and \code{asp} is defined with \code{numeric} value,
a new plot device is opened using \code{plot.window()}, and the \code{xlim}
and \code{ylim} values are passed to that function. As a result the
\code{graphics::par("usr")} values are used to define \code{xlim} and \code{ylim} for the
purpose of determining visible points, relevant to \code{applyRangeCeiling}.
}}

\item{applyRangeCeiling}{\code{logical} indicating how to handle points outside
the visible plot range. Valid values:
\describe{
\item{TRUE}{Points outside the viewing area are fixed to the
plot boundaries, in order to represent that there are additional
points outside the boundary. This setting is recommended when
the reasonable viewing area is smaller than the actual data,
for example to be consistent across plot panels, but where
you want to indicate that points may be outside the range.}
\item{FALSE}{Points outside the viewing area is not displayed,
with no special visual indication. This setting is useful when
data may contain a large number of points at \code{c(0, 0)} and the
density overwhelms the detail in the rest of the plot. In that
case setting \code{xlim=c(1e-10, 10)} and \code{applyRangeCeiling=FALSE}
would obscure these points.}
}}

\item{useRaster}{\code{logical} indicating whether to produce plots using the
\code{graphics::rasterImage()} function which produces a plot
raster image offline then scales this image to visible plot space.
This technique has two benefits:
\enumerate{
\item It produces substantially faster plot output.
\item Output contains substantially fewer plot objects, which results
in much smaller file sizes when saving in 'PDF' or 'SVG' format.
}}

\item{verbose}{\code{logical} indicating whether to print verbose output.}

\item{...}{additional arguments are passed to called functions,
including \code{getColorRamp()}, \code{nullPlot()}, \code{smoothScatterJam()}.}
}
\value{
\code{list} invisibly, sufficient to reproduce most of the
graphical parameters used to create the smooth scatter plot.
}
\description{
Produce scatter plot using point density instead of displaying
individual data points.
}
\details{
This function intends to make several potentially customizable
features of \code{graphics::smoothScatter()} plots much easier
to customize. For example bandwidthN allows defining the number of
bandwidth steps used by the kernel density function, and importantly
bases the number of steps on the visible plot window, and not the range
of data, which can differ substantially. The \code{nbin} argument is related,
but is used to define the level of detail used in the image function,
which when plotting numerous smaller panels, can be useful to reduce
unnecessary visual details.

This function also by default produces a raster image plot
with \code{useRaster=TRUE}, which adjusts the x- and y-bandwidth to
produce visually round density even when the x- and y-ranges
are very different.

Comments:
\itemize{
\item \code{asp=1} will define an aspect ratio 1, meaning the x-axis and y-axis
units will be the same physical size in the output device.
When this is true, and \code{fillBackground=TRUE} the \code{xlim} and \code{ylim}
values follow logic for \code{plot.default()} and \code{plot.window()} such that
each axis will include at least the \code{xlim} and \code{ylim} ranges, with
additional range included in order to maintain the plot aspect ratio.
\item When \code{asp}, and any of \code{xlim} or \code{ylim}, are defined, the data will
be "cropped" to respective \code{xlim} and \code{ylim} values as relevant,
after which the plot is drawn with the appropriate plot aspect ratio.
When \code{applyRangeCeiling=TRUE}, points outside the fixed \code{xlim} and \code{ylim}
range are fixed to the edge of the range, after which the plot is drawn
with the requested plot aspect ratio. It is recommended not to define
\code{xlim} and \code{ylim} when also defining \code{asp}.
\item When \code{add=TRUE} the \code{xlim} and \code{ylim} values are already defined
by the plot device. It is recommended not to define \code{xlim} and \code{ylim}
when \code{add=TRUE}.
}
}
\examples{
# doTest=TRUE invisibly returns the test data
x <- plotSmoothScatter(doTest=TRUE);

# so it can be plotted again with different settings
colnames(x) <- c("column_1", "column_2")
plotSmoothScatter(x, colramp="RdBu_r");

}
\seealso{
Other jam plot functions: 
\code{\link{adjustAxisLabelMargins}()},
\code{\link{coordPresets}()},
\code{\link{decideMfrow}()},
\code{\link{drawLabels}()},
\code{\link{getPlotAspect}()},
\code{\link{groupedAxis}()},
\code{\link{imageByColors}()},
\code{\link{imageDefault}()},
\code{\link{minorLogTicksAxis}()},
\code{\link{nullPlot}()},
\code{\link{plotPolygonDensity}()},
\code{\link{plotRidges}()},
\code{\link{shadowText}()},
\code{\link{shadowText_options}()},
\code{\link{showColors}()},
\code{\link{sqrtAxis}()},
\code{\link{usrBox}()}
}
\concept{jam plot functions}
