% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{rmNULL}
\alias{rmNULL}
\title{remove NULL entries from list}
\usage{
rmNULL(x, nullValue = NULL, ...)
}
\arguments{
\item{x}{\code{list} or other object which may contain NULL.}

\item{nullValue}{\code{character} optional replacement value, default NULL,
which causes the entry to be removed.}

\item{...}{additional arguments are ignored.}
}
\value{
list with NULL entries either removed, or replaced with nullValue.
This function is typically called so it removed list elements which are
NULL, resulting in a list that contains non-NULL entries. This function
can also be useful when NULL values should be changed to something else,
perhaps a character value "NULL" to be used as a label.
}
\description{
remove NULL entries from list
}
\details{
This function is a simple helper function to remove NULL from a list,
optionally replacing it with another value
}
\examples{
x <- list(A=1:6, B=NULL, C=letters[11:16]);
rmNULL(x)
rmNULL(x, nullValue=NA)

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
