% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{tcount}
\alias{tcount}
\title{frequency of entries, ordered by frequency}
\usage{
tcount(
  x,
  minCount = NULL,
  doSort = TRUE,
  maxCount = NULL,
  nameSortFunc = sort,
  ...
)
}
\arguments{
\item{x}{\code{character}, \code{numeric}, \code{factor} vector input to use when
calculating frequencies.}

\item{minCount}{optional \code{integer} minimum frequency, any results with
fewer counts observed will be omitted from results.}

\item{doSort}{\code{logical} whether to sort results decreasing by frequency.}

\item{maxCount}{optional \code{integer} maximum frequency for returned results.}

\item{nameSortFunc}{\code{function} used to sort results after sorting by
frequency. For example, one might use \code{mixedSort()}. If
\code{nameSortFunc=NULL} then no name sort will be applied.}

\item{...}{additional parameters are ignored.}
}
\value{
\code{integer} vector of counts, named by the unique input
values in \code{x}.
}
\description{
frequency of entries, ordered by frequency
}
\details{
This function mimics output from \code{table()} with two key
differences. It sorts the results by decreasing frequency, and optionally
filters results for a minimum frequency. It is effective when checking
for duplicate values, and ordering them by the number of occurrences.

This function is useful when working with large vectors of gene
identifiers, where it is not always obvious whether genes are replicated
in a particular technological assay. Transcript microarrays for example,
can contain many replicated genes, but often only a handful of genes are
highly replicated, while the rest are present only once or twice on the
array.
}
\examples{
testVector <- rep(c("one", "two", "three", "four"), c(1:4));
tcount(testVector);
tcount(testVector, minCount=2);

}
\seealso{
Other jam string functions: 
\code{\link{asSize}()},
\code{\link{breaksByVector}()},
\code{\link{fillBlanks}()},
\code{\link{formatInt}()},
\code{\link{gsubOrdered}()},
\code{\link{gsubs}()},
\code{\link{makeNames}()},
\code{\link{nameVector}()},
\code{\link{nameVectorN}()},
\code{\link{padInteger}()},
\code{\link{padString}()},
\code{\link{pasteByRow}()},
\code{\link{pasteByRowOrdered}()},
\code{\link{sizeAsNum}()},
\code{\link{ucfirst}()}
}
\concept{jam string functions}
