% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{find_discords_brute_force}
\alias{find_discords_brute_force}
\title{Finds a discord using brute force algorithm.}
\usage{
find_discords_brute_force(ts, w_size, discords_num)
}
\arguments{
\item{ts}{the input timeseries.}

\item{w_size}{the sliding window size.}

\item{discords_num}{the number of discords to report.}
}
\description{
Finds a discord using brute force algorithm.
}
\examples{
discords = find_discords_brute_force(ecg0606[1:600], 100, 1)
plot(ecg0606[1:600], type = "l", col = "cornflowerblue", main = "ECG 0606")
lines(x=c(discords[1,2]:(discords[1,2]+100)),
   y=ecg0606[discords[1,2]:(discords[1,2]+100)], col="red")
}
\references{
Keogh, E., Lin, J., Fu, A.,
HOT SAX: Efficiently finding the most unusual time series subsequence.
Proceeding ICDM '05 Proceedings of the Fifth IEEE International Conference on Data Mining
}
