% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/fit.R
\docType{methods}
\name{plot_fit}
\alias{plot_fit}
\alias{plot,IncrementTest,missing-method}
\title{Detection of Selective Processes}
\usage{
\S4method{plot}{IncrementTest,missing}(
  x,
  calendar = getOption("kairos.calendar"),
  col.neutral = "#004488",
  col.selection = "#BB5566",
  col.roll = "grey",
  flip = FALSE,
  ncol = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  ...
)
}
\arguments{
\item{x}{An \code{\linkS4class{IncrementTest}} object to be plotted.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[=calendar]{calendar()}}).}

\item{col.neutral, col.selection, col.roll}{A vector of colors.}

\item{flip}{A \code{\link{logical}} scalar: should the y-axis (ticks and numbering) be
flipped from side 2 (left) to 4 (right) from series to series when \code{facet}
is "\code{multiple}"?}

\item{ncol}{An \code{\link{integer}} specifying the number of columns to use when
\code{facet} is "\code{multiple}". Defaults to 1 for up to 4 series, otherwise to 2.}

\item{xlab, ylab}{A \code{\link{character}} vector giving the x and y axis labels.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{...}{Further parameters to be passed to \code{panel}
(e.g. \link[graphics:par]{graphical parameters}).}
}
\value{
\code{plot()} is called it for its side-effects: it results in a graphic being
displayed (invisibly returns \code{x}).
}
\description{
Produces an abundance \emph{vs} time diagram.
}
\details{
Results of the frequency increment test can be displayed on an abundance
\emph{vs} time diagram aid in the detection and quantification of selective
processes in the archaeological record. If \code{roll} is \code{TRUE}, each time
series is subsetted according to \code{window} to see if episodes of selection
can be identified among decoration types that might not show overall
selection. If so, shading highlights the data points where
\code{\link[=fit]{fit()}} identifies selection.
}
\note{
Displaying FIT results on an abundance \emph{vs} time diagram is adapted from Ben
Marwick's \href{https://github.com/benmarwick/signatselect/}{original idea}.
}
\examples{
## Data from Crema et al. 2016
data("merzbach", package = "folio")

## Keep only decoration types that have a maximum frequency of at least 50
keep <- apply(X = merzbach, MARGIN = 2, FUN = function(x) max(x) >= 50)
counts <- merzbach[, keep]

## Group by phase
## We use the row names as time coordinates (roman numerals)
dates <- as.numeric(utils::as.roman(rownames(counts)))

## Frequency Increment Test
freq <- fit(counts, dates, calendar = NULL)

## Plot time vs abundance
plot(freq, calendar = NULL, ncol = 3, xlab = "Phases")

## Plot time vs abundance and highlight selection
freq <- fit(counts, dates, calendar = NULL, roll = TRUE, window = 5)
plot(freq, calendar = NULL, ncol = 3, xlab = "Phases")
}
\seealso{
Other chronological analysis: 
\code{\link{apportion}()},
\code{\link{fit}()}
}
\author{
N. Frerebeau
}
\concept{chronological analysis}
