% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FixationFilterFunctions.R
\name{algorithm_i2mc}
\alias{algorithm_i2mc}
\title{Fixation detection by two-means clustering}
\usage{
algorithm_i2mc(
  gaze_raw,
  windowlength.ms = 200,
  distance.threshold = 0.7,
  one_degree = 40,
  window.step.size = 6,
  min.fixation.duration = 40,
  weight.threshold = 2,
  xcol = "x.raw",
  ycol = "y.raw",
  merge.ms.threshold = 40,
  downsampling.factors = NA,
  missing.samples.threshold = 0.5,
  threshold.on.off = 3
)
}
\arguments{
\item{gaze_raw}{Data frame with gaze data prior to fixation detection. Include the variable timestamp with timing in ms and columns with
x and y data as specified by the parameters xcol and ycol or their default values}

\item{windowlength.ms}{Length of the moving analysis windows}

\item{distance.threshold}{Subsequent fixations occurring withing this distance are merged. Set to 0 if you do not want to merge fixations.}

\item{one_degree}{One degree of the visual field in the unit of the raw x and y coordinates, typically pixels or proportion of the screen. Make
sure that the setting matches the format of your data}

\item{window.step.size}{Distance between starting points of subsequent analysis windows in samples}

\item{min.fixation.duration}{Minimum duration of accepted fixations. Shorter fixations are discarded}

\item{weight.threshold}{Samples with a transition weight exceeding it are candidates for fixation detection.}

\item{xcol}{Name of the column where raw x values are stored. Default: x.raw}

\item{ycol}{Name of the column where raw y values are stored. Default: y.raw}

\item{merge.ms.threshold}{Only fixations occurring within this time window in milliseconds are merged}

\item{downsampling.factors}{Factors to downsample the data by in calculating fixation weights. If downsampling.factors has the values \code{c(10, 2)}, transition weights will be calculated base on data in
the original sampling rate as well as the two downsampled data sets.}

\item{missing.samples.threshold}{Remove fixations with a higher proportion of missing samples. Range 0 to 1.}

\item{threshold.on.off}{if not NA, shift fixation onset and offset to exclude samples at the margin with absolute distances from the fixation center > threshold.on.off * MAD (distance) + median (distance)}
}
\value{
list including separate data frames for fixations and sample-by-sample data including gaze coordinates before ("raw") and after fixation detection.
The "fixations" data frame gives onset, offset, x, y, sample-to-sample root-mean-square deviations (RMSD, precision), RMSD from fixation centroid, and missing samples of each fixation.
}
\description{
Identify fixations in a gaze matrix using identification by two-means clustering. The algorithm is based on Hessels et al 2017. Behavior research methods, 49, 1802-1823.
Data from the left and right eye are not processed separately. Adjust your analysis scripts to include this steps if you want the algorithm to include this step, as in Hessels et al 2017.
Input data must be a data frame with the variables timestamp, x.raw and y.raw as variables. Other variables can
be included but will be ignored. This function does not perform pre-processing in the form of interpolation or smoothing. Use the function process.gaze for this.
Timestamps are assumed to be in milliseconds. X and y coordinates can be in pixels or proportion of the screen. Make sure that the parameter one_degree is consistent with the format of your data.
The output data is a list with two data frames: fixations includes all detected fixations with coordinates, duration
and a number of other metrics, filt.gaze is a sample-by-sample data frame with time stamps, raw gaze coordinates (e.g., before fixation detection)
and fixation coordinates.
If the input downsampling.factors is not empty, transition weights will be calculated based on the data in the original sampling rate and data at all sampling rate specified in this variable.
According to Hessels et al 2017, this step makes the analysis less vulnerable to noise in the data.
If the parameter threshold.on.off is not NA, the onsets and offsets of fixations will be shifted to exclude samples at the margins with a larger absolute distance from the
fixation centroid than a threshold value. The threshold value is defined as the median of all absolute distances from the centroid plus
threshold.on.off * MAD of the absolute distances. Default threshold is 3. Samples with large distances from the fixation centroid right at the onset and offset of a fixation may
belong to a saccade.
}
\examples{
gaze <- algorithm_i2mc(sample.data.processed)
}
