% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.kmfamset}
\alias{plot.kmneighbourhood}
\alias{plot.kmsurmiserelation}
\title{Plot a Hasse diagram}
\usage{
\method{plot}{kmfamset}(
  x,
  ...,
  horizontal = FALSE,
  colors = NULL,
  keepNames = TRUE,
  itemsep = ",",
  braces = TRUE,
  vertexshape = "box",
  arrowhead = "none",
  edgelabel = FALSE
)

\method{plot}{kmneighbourhood}(
  x,
  ...,
  horizontal = FALSE,
  colors = c("#eeee00", "#aaccff", "#bbffbb"),
  keepNames = TRUE,
  itemsep = ",",
  braces = TRUE,
  vertexshape = "oval",
  arrowhead = "none",
  edgelabel = FALSE,
  state
)

\method{plot}{kmsurmiserelation}(
  x,
  ...,
  horizontal = FALSE,
  colors = NULL,
  keepNames = TRUE,
  vertexshape = "circle",
  arrowhead = "none"
)
}
\arguments{
\item{x}{Binary matrix representing a family of sets}

\item{...}{Optional inherited parameters}

\item{horizontal}{Boolean defining orientation of the graph, default FALSE}

\item{colors}{Color value or vector (default NULL).}

\item{keepNames}{Keep item names (default TRUE)}

\item{itemsep}{Item separator in sets (default ','; only for families
of states)}

\item{braces}{Put braces around vertices (default TRUE; only for
families of states)}

\item{vertexshape}{Shape of the vertex objects, e.g. circle, oval, box, or none. See
\href{https://graphviz.org/doc/info/shapes.html}{Graphviz Node Shapes}
for a complete list of possible values.}

\item{arrowhead}{Form of the arrow head, e.g. vee or none. See
\href{https://graphviz.org/docs/attr-types/arrowType/}{Graphviz Arrow
Types} for a complete list of possible values.}

\item{edgelabel}{Boolean whether to label the edges of the diagram
(default FALSE)}

\item{state}{Knowledge state whose neighbourhood is to be pictured}
}
\description{
\code{plot} takes a matrix representing a family of sets (knowledge states)
or a surmise relation and a color vector, and draws a Hasse diagram.
If the color vector is NULL the states are drawn in green, the items in
the relation are drawn in orange.
}
\seealso{
Other Plotting knowledge structures: 
\code{\link{kmcolors}()}
}
\concept{Plotting knowledge structures}
