% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-sweep.R
\name{lcarsSweep}
\alias{lcarsSweep}
\title{LCARS sweep}
\usage{
lcarsSweep(
  column_inputs = NULL,
  left_inputs = NULL,
  right_inputs = NULL,
  title = NULL,
  subtitle = NULL,
  color = "atomic-tangerine",
  reverse = FALSE,
  expand = c(0, 0),
  column_width = 150,
  left_width = 0.5,
  width = "100\%"
)
}
\arguments{
\item{column_inputs}{optional input column for right side, for example a
column of buttons made with \code{inputColumn()}. See details.}

\item{left_inputs}{content on the left side of the sweep.}

\item{right_inputs}{content on the right side of the sweep.}

\item{title}{character, title for box with header.}

\item{subtitle}{character, subtitle for box with footer.}

\item{color}{sweep elbow colors. Any hex color or a named LCARS color.}

\item{reverse}{logical, create a reverse sweep.}

\item{expand}{integer, length-2 vector, the number of pixels to expand the
left and right content containers above or below the implicit border; the
top or bottom border where no sweep is present. See example.}

\item{column_width}{integer, width of the sweep column section in pixels.
Must be in pixels, 150 maximum. Smaller is permitted but will not conform as
well to LCARS style.}

\item{left_width}{numeric, number between 0 and 1 giving the proportional
width of the left content section.
The right section is 1 - \code{left_width}.}

\item{width}{a valid CSS unit, the width of the entire sweep. Fixed pixel
width recommended. See details.}
}
\value{
an HTML widget
}
\description{
Create an LCARS sweep; the 'S' or reverse-'S' shape comprised of two LCARS
elbows pointing in opposite directions.
The sweep is effectively two adjacent LCARS boxes separated by an input
column and some specific styling to achieve the sweep display.
}
\details{
There are limitations to the container responsiveness of the LCARS box and
sweep. In some cases, using percentage width, e.g., \code{width = "100\%"} will
work, but it may respond sluggishly or may not work at all. Fixed pixel width
is recommended for \code{lcarsBox()} and \code{lcarsSweep()}. Regardless of
responsiveness, these widgets are also not intended to fit very small displays.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

  library(ggplot2)
  d <- data.frame(x = rnorm(500))
  g <- ggplot(d, aes(x)) + theme_lcars_dark()
  g1 <- g + geom_histogram(color = "black", fill = "#9999FF", bins = 20) +
    ggtitle("Plot 1")
  left <- div(h4("Some text"), p("The fine print."))

  ui <- lcarsPage(
    lcarsHeader("LCARS sweep"),
    h4("Change colors and relative widths of content sections"),
    h4("Add title and subtitle, input column padding, and content"),
    lcarsSweep(
      inputColumn(
        lcarsButton("x1", "Button"),
        lcarsRect(color = "hopbush", height = 80)
      ),
      left, plotOutput("plot1", height = 650), # plot taller than sweep box
      title = "Title", subtitle = "Subtitle",
      color = "pale-canary", left_width = 0.3, width = 900,
      expand = c(0, 350) # negative bottom margin added to right side div
    ),
    lcarsSweep( # content from sweep box above extends into sweep box below
      inputColumn(
        lcarsButton("x2", "Button A"),
        lcarsButton("x3", "Button B"),
        lcarsRect(color = "lilac")
      ),
      left, title = "Title 2", subtitle = "Subtitle 2",
      color = "anakiwa", reverse = TRUE, left_width = 0.3, width = 900
    )
  )

  server <- function(input, output) {
    output$plot1 <- renderPlot(g1)
  }

  shinyApp(ui, server)
}
}
\seealso{
\code{\link[=lcarsBox]{lcarsBox()}}
}
