% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-dsm.R
\name{dsm_point2raster}
\alias{dsm_point2raster}
\alias{p2r}
\title{Digital Surface Model Algorithm}
\usage{
p2r(subcircle = 0, na.fill = NULL)
}
\arguments{
\item{subcircle}{numeric. Radius of the circles. To obtain fewer empty pixels the algorithm
can replace each return with a circle composed of 8 points (see details).}

\item{na.fill}{function. A function that implements an algorithm to compute spatial interpolation
to fill the empty pixel often left by points-to-raster methods. \code{lidR} has \link{knnidw},
\link{tin}, and \link{kriging} (see also \link{rasterize_terrain} for more details).}
}
\description{
This function is made to be used in \link{rasterize_canopy}. It implements an algorithm for digital
surface model computation based on a points-to-raster method: for each pixel of the output raster
the function attributes the height of the highest point found. The \code{subcircle} tweak replaces
each point with 8 points around the original one. This allows for virtual 'emulation' of the fact
that a lidar point is not a point as such, but more realistically a disc. This tweak densifies the
point cloud and the resulting canopy model is smoother and contains fewer 'pits' and empty pixels.
}
\examples{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las <- readLAS(LASfile)
col <- height.colors(50)

# Points-to-raster algorithm with a resolution of 1 meter
chm <- rasterize_canopy(las, res = 1, p2r())
plot(chm, col = col)

# Points-to-raster algorithm with a resolution of 0.5 meters replacing each
# point by a 20 cm radius circle of 8 points
chm <- rasterize_canopy(las, res = 0.5, p2r(0.2))
plot(chm, col = col)

\dontrun{
chm <- rasterize_canopy(las, res = 0.5, p2r(0.2, na.fill = tin()))
plot(chm, col = col)
}
}
\seealso{
Other digital surface model algorithms: 
\code{\link{dsm_pitfree}},
\code{\link{dsm_tin}}
}
\concept{digital surface model algorithms}
