% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_sleep.R
\name{plot_sleep}
\alias{plot_sleep}
\title{Plot sleep.}
\usage{
plot_sleep(person, plot_type = "all", ...)
}
\arguments{
\item{person}{An instance of the Person class}

\item{plot_type}{The type of plot.  Options include: "by_weekday", 
"by_start_end_time", "by_datetime", "by_restless_prop", 
"by_restless_min", "by_quality".  Default is to plot all six.}

\item{...}{Extra arguments used to specify the `color_var` for the 
`by_start_end_time` plot}
}
\value{
NULL, but plots print to screen
}
\description{
Prints one of six plots: two are related to quantity of sleep, 
and four are related to quality of sleep
1.  Sleep by day of week (bar graph)
2.  Start and end of sleep period for each day in the range
3.  Duration of sleep and time asleep over time
4.  Proportion of time spent restless out of total sleep duration over time
5.  Time spent restless over time (in minutes)
6.  Sleep quality over time (subjective score, out of 100)
}
\examples{
data(EX)
plot_sleep(person = EX)

}
