### $Id: Earthquake.q,v 1.2 1998/04/10 22:52:03 bates Exp $
### Data on the severity of earthquakes
### Joyner and Boore (1981), Bull. Seismological Soc. of Amer., 71, 2011-2038
### cited in Brillinger (1987), Statistical Science, 2, 448-450 and in
### Davidian and Giltinan (1995), section 11.5
"Earthquake" <-
  structure(list
  (Quake = structure(ordered(c(1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 5, 6, 6, 6, 
     6, 6, 4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 10, 10, 11, 13, 13, 13, 13, 
     13, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 14, 14, 
     14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 17, 17, 17, 17, 
     17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
     17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
     17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 
     19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
     19, 19, 19, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 
     22, 23, 23, 23), levels=1:23), class = c("ordered", "factor"),
     .Label = c("20", 
       "16", "14", "10", "3", "8", "23", "22", "6", "13", "7", "21", 
       "18", "15", "4", "12", "19", "5", "9", "1", "2", "17", "11")),
   Richter = c(5, 
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5.1, 5.1, 5.1, 5.2, 
     5.2, 5.2, 5.2, 5.3, 5.3, 5.3, 5.3, 5.3, 5.3, 5.3, 5.3, 5.3, 5.3, 
     5.3, 5.3, 5.3, 5.3, 5.3, 5.3, 5.3, 5.3, 5.3, 5.3, 5.3, 5.3, 5.3, 
     5.3, 5.3, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.6, 
     5.6, 5.6, 5.7, 5.8, 5.8, 5.8, 5.8, 5.8, 5.8, 5.8, 5.8, 5.8, 5.8, 
     5.8, 5.8, 5.8, 5.8, 5.8, 5.8, 5.8, 5.8, 6, 6, 6, 6, 6.1, 6.1, 
     6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.2, 6.5, 6.5, 6.5, 6.5, 6.5, 
     6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 
     6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 
     6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 
     6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 
     6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 
     6.6, 7, 7.4, 7.4, 7.4, 7.4, 7.4, 7.4, 7.4, 7.4, 7.4, 7.4, 7.6, 
     7.6, 7.6, 7.7, 7.7, 7.7),
   distance = c(7.5, 8.8, 8.9, 9.4, 9.7, 
     9.7, 10.5, 10.5, 12, 12.2, 12.8, 14.6, 14.9, 17.6, 23.9, 25, 
     2.9, 3.2, 7.6, 17, 8, 10, 10, 8, 19, 21, 13, 22, 29, 31, 5.8, 
     12, 12.1, 20.5, 20.5, 25.3, 35.9, 36.1, 36.3, 38.5, 41.4, 43.6, 
     44.4, 46.1, 47.1, 47.7, 49.2, 53.1, 4, 10.1, 11.1, 17.7, 22.5, 
     26.5, 29, 30.9, 37.8, 48.3, 62, 50, 16, 62, 1.2, 1.6, 9.1, 3.7, 
     5.3, 7.4, 17.9, 19.2, 23.4, 30, 38.9, 10.8, 15.7, 16.7, 20.8, 
     28.5, 33.1, 40.3, 8, 32, 30, 31, 16.1, 63.6, 6.6, 9.3, 13, 17.3, 
     105, 112, 123, 5, 23.5, 26, 0.5, 0.6, 1.3, 1.4, 2.6, 3.8, 4, 
     5.1, 6.2, 6.8, 7.5, 7.6, 8.4, 8.5, 8.5, 10.6, 12.6, 12.7, 12.9, 
     14, 15, 16, 17.7, 18, 22, 22, 23, 23.2, 29, 32, 32.7, 36, 43.5, 
     49, 60, 64, 105, 122, 141, 200, 45, 130, 147, 187, 197, 203, 
     211, 17, 19.6, 20.2, 21.1, 21.9, 24.2, 66, 87, 23.4, 24.6, 25.7, 
     28.6, 37.4, 46.7, 56.9, 60.7, 61.4, 62, 64, 82, 88, 91, 12, 148, 
     42, 85, 107, 109, 156, 224, 293, 359, 370, 25.4, 32.9, 92.2, 
     45, 145, 300),
   soil = structure(factor(c(2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 1, 1, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 1, 1, 2, 2, 2, 2, 2, 
     2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 
     1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 1, 1, 2), levels=1:2), class = "factor",
     .Label = c("0", "1")),
   accel = c(0.264, 0.263, 0.23, 0.147, 0.286, 0.157, 0.237, 
     0.133, 0.055, 0.097, 0.129, 0.192, 0.147, 0.154, 0.06, 0.057, 
     0.21, 0.39, 0.28, 0.011, 0.12, 0.17, 0.14, 0.127, 0.086, 0.179, 
     0.205, 0.073, 0.045, 0.03, 0.123, 0.133, 0.073, 0.097, 0.096, 
     0.23, 0.082, 0.11, 0.11, 0.094, 0.04, 0.05, 0.022, 0.07, 0.08, 
     0.033, 0.017, 0.022, 0.259, 0.267, 0.071, 0.275, 0.058, 0.026, 
     0.039, 0.112, 0.065, 0.026, 0.005, 0.031, 0.13, 0.003, 0.42, 
     0.23, 0.13, 0.26, 0.27, 0.26, 0.11, 0.12, 0.038, 0.044, 0.046, 
     0.12, 0.154, 0.052, 0.045, 0.086, 0.056, 0.065, 0.11, 0.04, 0.07, 
     0.08, 0.411, 0.018, 0.509, 0.467, 0.279, 0.072, 0.012, 0.006, 
     0.003, 0.39, 0.17, 0.21, 0.32, 0.52, 0.72, 0.32, 0.81, 0.64, 
     0.56, 0.51, 0.4, 0.61, 0.26, 0.24, 0.46, 0.22, 0.23, 0.28, 0.38, 
     0.27, 0.31, 0.2, 0.11, 0.43, 0.27, 0.15, 0.15, 0.15, 0.13, 0.19, 
     0.13, 0.066, 0.35, 0.1, 0.16, 0.14, 0.049, 0.034, 0.018, 0.048, 
     0.011, 0.007, 0.142, 0.031, 0.006, 0.01, 0.01, 0.006, 0.013, 
     0.374, 0.2, 0.147, 0.188, 0.204, 0.335, 0.057, 0.021, 0.152, 
     0.217, 0.114, 0.15, 0.148, 0.112, 0.043, 0.057, 0.03, 0.027, 
     0.028, 0.034, 0.03, 0.039, 0.359, 0.014, 0.196, 0.135, 0.062, 
     0.054, 0.014, 0.018, 0.01, 0.004, 0.004, 0.16, 0.064, 0.09, 0.11, 
     0.01, 0.01)),
row.names = c("132", "133", "134", "135", "136", 
  "137", "138", "139", "140", "141", "142", "143", "144", "145", 
  "146", "147", "77", "78", "79", "69", "70", "71", "72", "12", 
  "35", "36", "37", "38", "39", "62", "165", "166", "167", "168", 
  "169", "170", "171", "172", "173", "174", "175", "176", "177", 
  "178", "179", "180", "181", "182", "155", "156", "157", "158", 
  "159", "160", "161", "162", "163", "164", "33", "67", "68", "34", 
  "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", 
  "148", "149", "150", "151", "152", "153", "154", "73", "74", 
  "75", "76", "13", "14", "15", "16", "17", "18", "19", "20", "21", 
  "66", "94", "95", "96", "97", "98", "99", "100", "101", "102", 
  "103", "104", "105", "106", "107", "108", "109", "110", "111", 
  "112", "113", "114", "115", "116", "117", "118", "119", "120", 
  "121", "122", "123", "124", "125", "126", "127", "128", "129", 
  "130", "131", "22", "23", "24", "25", "26", "27", "28", "29", 
  "30", "31", "32", "40", "41", "42", "43", "44", "45", "46", "47", 
  "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", 
  "59", "60", "61", "1", "2", "3", "4", "5", "6", "7", "8", "9", 
  "10", "11", "80", "81", "82", "63", "64", "65"),
class = c("nfnGroupedData", "nfGroupedData",
  "groupedData", "data.frame"),
formula = accel ~ distance | Quake,
labels = list(x = "Distance from epicenter", y = "acceleration"),
units = list(x = "(km)", y = "(g)"))
