% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopFuns.R
\name{qevd_vector}
\alias{qevd_vector}
\title{Return a Vector of EVD Quantiles}
\usage{
qevd_vector(x, p, evd_mod_str, interval = NULL, lower.tail = TRUE, nams = NULL)
}
\arguments{
\item{x}{vector of EVD parameters}

\item{p}{vector of probabilities.}

\item{evd_mod_str}{either a string "fgumbel", "fgev" or "fgumbelx" from the extreme value distribution (evd) in the evd package}

\item{interval}{A length two vector containing the end-points of the interval to be searched for the quantiles, passed to the uniroot function.}

\item{lower.tail}{Logical; if TRUE (default), P (X <= x), otherwise P (X > x).}

\item{nams}{names of the values of x (optional)}
}
\value{
gives the quantile function corresponding to p
}
\description{
Return a Vector of EVD Quantiles
}
\examples{
qevd_vector(c(1,0.5),1-0.05,"fgumbel",nams = c("loc","scale"))
df = data.frame(loc = 1,scale = 0.5)
qevd_vector(df,1-0.05,"fgumbel")

}
\seealso{
\code{\link[evd:gev]{evd::qgev()}}, \code{\link[evd:gumbelx]{evd::qgumbelx()}}
}
