% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops-%m+%.r
\name{rollback}
\alias{rollback}
\title{Roll back date to last day of previous month}
\usage{
rollback(dates, roll_to_first = FALSE, preserve_hms = TRUE)
}
\arguments{
\item{dates}{A POSIXct, POSIXlt or Date class object.}

\item{roll_to_first}{Rollback to the first day of the month instead of the
last day of the previous month}

\item{preserve_hms}{Retains the same hour, minute, and second information? If
FALSE, the new date will be at 00:00:00.}
}
\value{
A date-time object of class POSIXlt, POSIXct or Date, whose day has
been adjusted to the last day of the previous month, or to the first day of
the month.
}
\description{
rollback changes a date to the last day of the previous month or to the first
day of the month. Optionally, the new date can retain the same hour, minute,
and second information.
}
\examples{
date <- ymd("2010-03-03")
rollback(date)

dates <- date + months(0:2)
rollback(dates)

date <- ymd_hms("2010-03-03 12:44:22")
rollback(date)
rollback(date, roll_to_first = TRUE)
rollback(date, preserve_hms = FALSE)
rollback(date, roll_to_first = TRUE, preserve_hms = FALSE)
}

