% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magpie-class.R
\docType{class}
\name{magpie-class}
\alias{magpie-class}
\alias{as.magpie}
\alias{as.magpie-methods}
\alias{as.magpie,magpie-method}
\alias{as.magpie,array-method}
\alias{as.magpie,lpj-method}
\alias{as.magpie,data.frame-method}
\alias{as.magpie,numeric-method}
\alias{as.magpie,NULL-method}
\alias{as.magpie,quitte-method}
\alias{as.magpie,tbl_df-method}
\alias{as.magpie,RasterBrick-method}
\alias{as.magpie,RasterLayer-method}
\alias{as.magpie,RasterStack-method}
\alias{is.magpie}
\alias{[,magpie-method}
\alias{[,magpie,ANY,ANY-method}
\alias{[<-,magpie,ANY,ANY-method}
\alias{[<-,magpie-method}
\alias{Ops,magpie,magpie-method}
\alias{Ops,magpie,numeric-method}
\alias{Ops,numeric,magpie-method}
\title{Class "magpie" ~~~}
\arguments{
\item{x}{An object that should be either tested or transformed as/to an
MAgPIE-object.}

\item{...}{additional arguments supplied for the conversion to a MAgPIE
object. Allowed arguments for arrays and dataframes are \code{spatial} and
\code{temporal} both expecting a vector of dimension or column numbers which
contain the spatial or temporal information. By default both arguments are
set to NULL which means that the \code{as.magpie} will try to detect
automatically the temporal and spatial dimensions. The arguments will just
overwrite the automatic detection. If you want to specify that the data does
not contain a spatial or temporal dimension you can set the corresponding
argument to 0. In addition \code{as.magpie} for data.frames is also
expecting an argument called \code{datacol} which expects a number stating
which is the first column containing data. This argument should be used if
the dimensions are not detected corretly, e.g. if the last dimension column
contains years which are then detected as values and therefore interpreted
as first data column. In addition an argument \code{tidy=TRUE} can be used
to indicate that the data.frame structure is following the rules of tidy
data (last column is the data column all other columns contain dimension
information). This information will help the conversion. \code{sep} defines
the dimension separator (default is ".") and \code{replacement} defines how 
the separator as a reserved character should be converted in order to not
mess up with the object (default "_").
Another available argument for conversions of data.frames and quitte 
objects to magpie is \code{filter} if set to TRUE (default)
"." (separator) will be replaced withe the \code{replacement} character and
empty entries will be replaced with a single space. If set to FALSE no filter 
will be applied to the data.}
}
\description{
The MAgPIE class is a data format for cellular MAgPIE data with a close
relationship to the array data format. \code{is.magpie} tests if \code{x} is
an MAgPIE-object, \code{as.magpie} transforms \code{x} to an MAgPIE-object
(if possible).
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("magpie", data, dim, dimnames, ...)}. MAgPIE objects have three
dimensions (cells,years,datatype) and the dimensionnames of the first
dimension have the structure "REGION.cellnumber". MAgPIE-objects behave the
same like array-objects with 2 exceptions: \cr 1.Dimensions of the object
will not collapse (e.g. \code{x[1,1,1]} will remain 3D instead of becoming
1D)\cr 2.It is possible to extract full regions just by typing
\code{x["REGIONNAME",,]}. \cr\cr

Please mind following standards: \cr Header must not contain any purely
numeric entries, but combinations of characters and numbers are allowed
(e.g. "bla","12" is forbidden, wheras "bla","b12" is allowed)\cr Years
always have the structure "y" + 4-digit number, e.g. "y1995"\cr Regions
always have the structure 3 capital letters, e.g. "AFR" or "GLO"\cr\cr This
standards are necessary to allow the scripts to detect headers, years and
regions properly and to have a distinction to other data.
}

\examples{

showClass("magpie")

pop <- maxample("pop")

# returning PAO and PAS for 2025
pop["PA",2025,,pmatch="left"]

# returning CPA for 2025
pop["PA",2025,,pmatch="right"]

# returning CPA PAO and PAS for 2025
pop["PA",2025,,pmatch=TRUE]

# returning PAS and 2025
pop["PAS",2025,]

# returning everything but values for PAS or values for 2025
pop["PAS",2025,,invert=TRUE]

# accessing subdimension via set name

a <- maxample("animal")
a[list(country="NLD",y="53p25"),,list(species=c("rabbit","dog"))]

# please note that the list elements act as filter. For instance, the 
# following example will not contain any dogs as the data set does
# not contain any dogs which are black.
a[list(country="NLD",y="53p25"),,list(species=c("rabbit","dog"), color="black")]

# it is also possible to extract given combinations of subdimensions
# via a data-frame
df <- data.frame(getItems(a,3,split=TRUE,full=TRUE))[c(1,3,4),][3:2]
getItems(a[df],3)

# Unknown dimensions to be added in output!
df$blub <- paste0("bl",1:dim(df)[1])
getItems(a[df],3)

}
\seealso{
\code{\link{read.magpie}}, \code{\link{write.magpie}},
\code{\link{getRegions}}, \code{\link{getYears}}, \code{\link{getNames}},
\code{\link{getCPR}}, \code{\link{ncells}}, \code{\link{nyears}},
\code{\link{ndata}}
}
\author{
Jan Philipp Dietrich
}
\keyword{classes}
