% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mselect.R
\name{mselect}
\alias{mselect}
\alias{mselect<-}
\title{MSelect}
\usage{
mselect(x, ..., collapseNames = FALSE)

mselect(x, ...) <- value
}
\arguments{
\item{x}{MAgPIE object}

\item{...}{entry selections of the form
\code{set_name=c(set_elem1,set_elem2)}. Alternatively a single list element
containing these selections can be provided.}

\item{collapseNames}{Boolean which decides whether names should be collapsed
or not.}

\item{value}{values on which the selected magpie entries should be set.}
}
\value{
The reduced MAgPIE object containing only the selected entries or
the full MAgPIE object in which a selection of entries was manipulated.
}
\description{
Select values from a MAgPIE-object
}
\details{
This functions only work for MAgPIE objects with named dimensions as the
dimension name (set_name) has to be used to indicate in which dimension the
entries should be searched for!
}
\section{Functions}{
\itemize{
\item \code{mselect<-}: replace values in magpie object
}}

\examples{

pop <- maxample("pop")
mselect(pop, i = c("AFR", "EUR"), scenario = "A2", t = "y2035")
}
\seealso{
\code{\link{collapseNames}}, \code{"\linkS4class{magpie}"}
}
\author{
Jan Philipp Dietrich
}
