% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{build_pedigrees}
\alias{build_pedigrees}
\title{Build pedigrees from (individuals in) a population.}
\usage{
build_pedigrees(population, progress = TRUE)
}
\arguments{
\item{population}{Population generated by \code{\link[=sample_geneology]{sample_geneology()}} or \code{\link[=sample_geneology_varying_size]{sample_geneology_varying_size()}}.}

\item{progress}{Show progress.}
}
\value{
An object with class \code{malan_pedigreelist} (an internal list of external pointers to pedigrees).
}
\description{
In a newly simulated population, each individual only knows its father and children.
Using this information, this function builds pedigrees.
This makes it easier to e.g. population haplotypes, find path between two individuals
(if they are not in the same pedigree, they are not connected).
}
\examples{
sim <- sample_geneology(100, 10)
str(sim, 1)
sim$population
peds <- build_pedigrees(sim$population)
peds

}
\seealso{
\code{\link[=sample_geneology]{sample_geneology()}} and \code{\link[=sample_geneology_varying_size]{sample_geneology_varying_size()}} for simulating populations.
}
