% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{resolving}
\alias{resolving}
\alias{resolve_coalesce}
\alias{resolve_unite}
\alias{resolve_min}
\alias{resolve_max}
\alias{resolve_random}
\alias{resolve_precision}
\title{Resolving multiple observations of the same variable into one}
\usage{
resolve_coalesce(.data, vars)

resolve_unite(.data, vars)

resolve_min(.data, vars)

resolve_max(.data, vars)

resolve_random(.data, vars)

resolve_precision(.data, vars)
}
\arguments{
\item{.data}{A data frame or tibble containing the variables.}

\item{vars}{A vector of variables from \code{.data} to be resolved or converged.}
}
\description{
Resolving multiple observations of the same variable into one
}
\section{Unite}{

Note that uniting always returns a character/string vector.
Values are separated by commas and a set is contained within braces.
}

\examples{
test <- data.frame(bloop.x = c(1,6,NA), 
                   bloop.y = c(2,NA,3), bloop = c(NA,3,4))
resolve_coalesce(test)
resolve_unite(test)
resolve_min(test)
resolve_max(test)
resolve_random(test)
resolve_precision(test)
}
