% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legends.R
\name{map_legends}
\alias{map_legends}
\alias{legend_style}
\alias{add_legend}
\alias{add_categorical_legend}
\alias{add_continuous_legend}
\alias{clear_legend}
\title{Add legends to maps with customizable styling}
\usage{
legend_style(
  background_color = NULL,
  background_opacity = NULL,
  border_color = NULL,
  border_width = NULL,
  border_radius = NULL,
  text_color = NULL,
  text_size = NULL,
  title_color = NULL,
  title_size = NULL,
  font_family = NULL,
  title_font_family = NULL,
  font_weight = NULL,
  title_font_weight = NULL,
  element_border_color = NULL,
  element_border_width = NULL,
  shadow = NULL,
  shadow_color = NULL,
  shadow_size = NULL,
  padding = NULL
)

add_legend(
  map,
  legend_title,
  values,
  colors,
  type = c("continuous", "categorical"),
  circular_patches = FALSE,
  position = "top-left",
  sizes = NULL,
  add = FALSE,
  unique_id = NULL,
  width = NULL,
  layer_id = NULL,
  margin_top = NULL,
  margin_right = NULL,
  margin_bottom = NULL,
  margin_left = NULL,
  style = NULL
)

add_categorical_legend(
  map,
  legend_title,
  values,
  colors,
  circular_patches = FALSE,
  position = "top-left",
  unique_id = NULL,
  sizes = NULL,
  add = FALSE,
  width = NULL,
  layer_id = NULL,
  margin_top = NULL,
  margin_right = NULL,
  margin_bottom = NULL,
  margin_left = NULL,
  style = NULL
)

add_continuous_legend(
  map,
  legend_title,
  values,
  colors,
  position = "top-left",
  unique_id = NULL,
  add = FALSE,
  width = NULL,
  layer_id = NULL,
  margin_top = NULL,
  margin_right = NULL,
  margin_bottom = NULL,
  margin_left = NULL,
  style = NULL
)

clear_legend(map, legend_ids = NULL)
}
\arguments{
\item{background_color}{Background color for the legend container (e.g., "white", "#ffffff").}

\item{background_opacity}{Opacity of the legend background (0-1, where 1 is fully opaque).}

\item{border_color}{Color of the legend border (e.g., "black", "#000000").}

\item{border_width}{Width of the legend border in pixels.}

\item{border_radius}{Border radius for rounded corners in pixels.}

\item{text_color}{Color of the legend text (e.g., "black", "#000000").}

\item{text_size}{Size of the legend text in pixels.}

\item{title_color}{Color of the legend title text.}

\item{title_size}{Size of the legend title text in pixels.}

\item{font_family}{Font family for legend text (e.g., "Arial", "Times New Roman", "Open Sans").}

\item{title_font_family}{Font family for legend title (defaults to font_family if not specified).}

\item{font_weight}{Font weight for legend text (e.g., "normal", "bold", "lighter", or numeric like 400, 700).}

\item{title_font_weight}{Font weight for legend title (defaults to font_weight if not specified).}

\item{element_border_color}{Color for borders around legend elements (color bar for continuous, patches/circles for categorical).}

\item{element_border_width}{Width in pixels for borders around legend elements.}

\item{shadow}{Logical, whether to add a drop shadow to the legend.}

\item{shadow_color}{Color of the drop shadow (e.g., "black", "rgba(0,0,0,0.3)").}

\item{shadow_size}{Size/blur radius of the drop shadow in pixels.}

\item{padding}{Internal padding of the legend container in pixels.}

\item{map}{A map object created by the \code{mapboxgl} or \code{maplibre} function.}

\item{legend_title}{The title of the legend.}

\item{values}{The values being represented on the map (either a vector of categories or a vector of stops).}

\item{colors}{The corresponding colors for the values (either a vector of colors, a single color, or an interpolate function).}

\item{type}{One of "continuous" or "categorical" (for \code{add_legend} only).}

\item{circular_patches}{Logical, whether to use circular patches in the legend (only for categorical legends).}

\item{position}{The position of the legend on the map (one of "top-left", "bottom-left", "top-right", "bottom-right").}

\item{sizes}{An optional numeric vector of sizes for the legend patches, or a single numeric value (only for categorical legends).}

\item{add}{Logical, whether to add this legend to existing legends (TRUE) or replace existing legends (FALSE). Default is FALSE.}

\item{unique_id}{Optional. A unique identifier for the legend. If not provided, a random ID will be generated.}

\item{width}{The width of the legend. Can be specified in pixels (e.g., "250px") or as "auto". Default is NULL, which uses the built-in default.}

\item{layer_id}{The ID of the layer that this legend is associated with. If provided, the legend will be shown/hidden when the layer visibility is toggled.}

\item{margin_top}{Custom top margin in pixels, allowing for fine control over legend positioning. Default is NULL (uses standard positioning).}

\item{margin_right}{Custom right margin in pixels. Default is NULL.}

\item{margin_bottom}{Custom bottom margin in pixels. Default is NULL.}

\item{margin_left}{Custom left margin in pixels. Default is NULL.}

\item{style}{Optional styling options created by \code{legend_style()} or a list of style options.}

\item{legend_ids}{Optional. A character vector of legend IDs to clear (for \code{clear_legend} only). If not provided, all legends will be cleared.}
}
\value{
\describe{
\item{add_legend, add_categorical_legend, add_continuous_legend}{The updated map object with the legend added.}
\item{legend_style}{A list of class "mapgl_legend_style" containing the styling options.}
\item{clear_legend}{The updated map object with the specified legend(s) cleared.}
}
}
\description{
These functions provide a comprehensive system for adding categorical and continuous
legends to Mapbox GL and MapLibre GL maps, with extensive styling customization options.
}
\section{Legend Styling}{

The \code{legend_style()} function creates user-friendly styling options:

\describe{
\item{Container styling}{\code{background_color}, \code{background_opacity}, \code{border_color}, \code{border_width}, \code{border_radius}, \code{padding}}
\item{Typography}{\code{font_family}, \code{title_font_family}, \code{font_weight}, \code{title_font_weight}, \code{text_color}, \code{title_color}, \code{text_size}, \code{title_size}}
\item{Element borders}{\code{element_border_color}, \code{element_border_width} (for patches/circles and color bars)}
\item{Shadows}{\code{shadow}, \code{shadow_color}, \code{shadow_size}}
}
}

\examples{
\dontrun{
# Basic categorical legend
add_legend(map, "Population", 
          values = c("Low", "Medium", "High"),
          colors = c("blue", "yellow", "red"),
          type = "categorical")

# Continuous legend with custom styling using legend_style()
add_legend(map, "Income", 
          values = c(0, 50000, 100000),
          colors = c("blue", "yellow", "red"),
          type = "continuous",
          style = legend_style(
            background_color = "white",
            background_opacity = 0.9,
            border_width = 2,
            border_color = "navy",
            text_color = "darkblue",
            font_family = "Times New Roman",
            title_font_weight = "bold"
          ))
          
# Legend with custom styling using a list
add_legend(map, "Temperature", 
          values = c(0, 50, 100),
          colors = c("blue", "yellow", "red"),
          type = "continuous",
          style = list(
            background_color = "#f0f0f0",
            title_size = 16,
            text_size = 12,
            shadow = TRUE,
            shadow_color = "rgba(0,0,0,0.1)",
            shadow_size = 8
          ))

# Dark legend with white element borders
add_legend(map, "Elevation", 
          values = c(0, 1000, 2000, 3000),
          colors = c("#2c7bb6", "#abd9e9", "#fdae61", "#d7191c"),
          type = "continuous",
          style = legend_style(
            background_color = "#2c3e50",
            text_color = "white",
            title_color = "white",
            element_border_color = "white",
            element_border_width = 1
          ))
          
# Categorical legend with circular patches and styling
add_categorical_legend(
    map = map,
    legend_title = "Population",
    values = c("Low", "Medium", "High"),
    colors = c("#FED976", "#FEB24C", "#FD8D3C"),
    circular_patches = TRUE,
    sizes = c(10, 15, 20),
    style = legend_style(
      background_opacity = 0.95,
      border_width = 1,
      border_color = "gray",
      title_color = "navy",
      element_border_color = "black",
      element_border_width = 1
    )
)

# Create reusable legend styling
dark_style <- legend_style(
  background_color = "#2c3e50",
  text_color = "white",
  title_color = "white",
  font_family = "Arial",
  title_font_weight = "bold",
  element_border_color = "white",
  element_border_width = 1,
  shadow = TRUE,
  shadow_color = "rgba(0,0,0,0.3)",
  shadow_size = 6
)

# Clear specific legends
clear_legend(map_proxy, legend_ids = c("legend-1", "legend-2"))
}
}
