% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preferential_pairing.R
\name{calc_prefpair_profiles}
\alias{calc_prefpair_profiles}
\title{Preferential pairing profiles}
\usage{
calc_prefpair_profiles(input.genoprobs, verbose = TRUE)
}
\arguments{
\item{input.genoprobs}{an object of class \code{mappoly.genoprob}}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}
}
\description{
Given the genotype conditional probabilities for a map, this function
computes the probability profiles for all possible homolog pairing 
configurations in both parents.
}
\examples{
\donttest{
  ## tetraploid example
  w1 <- lapply(solcap.dose.map[1:12], calc_genoprob)
  x1 <- calc_prefpair_profiles(w1)
  print(x1)
  plot(x1)
}

}
\references{
Mollinari M., Olukolu B. A.,  Pereira G. da S., 
    Khan A., Gemenet D., Yencho G. C., Zeng Z-B. (2020), 
    Unraveling the Hexaploid Sweetpotato Inheritance 
    Using Ultra-Dense Multilocus Mapping, 
    _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400620}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu} and Guilherme Pereira, \email{g.pereira@cgiar.org}
}
