% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maraca.R
\name{plot_maraca}
\alias{plot_maraca}
\title{Creates and returns the plot of the maraca data.}
\usage{
plot_maraca(
  obj,
  continuous_grid_spacing_x = NULL,
  trans = c("identity", "log", "log10", "sqrt", "reverse")[1],
  density_plot_type = c("default", "violin", "box", "scatter")[1],
  vline_type = NULL,
  theme = "maraca"
)
}
\arguments{
\item{obj}{an object of S3 class 'maraca'}

\item{continuous_grid_spacing_x}{The spacing of the x grid to use for the
continuous section of the plot.}

\item{trans}{the transformation to apply to the x-axis scale for the last
outcome. Possible values are "identity", "log" (only for continuous
endpoint), "log10" (only for continuous endpoint), "sqrt" (only for
continuous endpoint) and "reverse". The default value is "identity".}

\item{density_plot_type}{which type of plot to display in the continuous
part of the plot. Options are "default", "violin", "box", "scatter".}

\item{vline_type}{what the vertical dashed line should represent. Accepts
"median" (only for continuous last endpoint), "mean", "none" and
NULL (default). By default (vline_type = NULL), vline_type will be
set to "median" for a continuous last endpoint and to "mean" for
a binary last endpoint.}

\item{theme}{Choose theme to style the plot. The default theme is "maraca".
Options are "maraca", "maraca_old", "color1", "color2" and none".
For more details, check the vignette called
"Maraca Plots - Themes and Styling".}
}
\value{
a ggplot2 object of the data. This function
will not render the plot immediately. You have to print() the returned
object for it to be displayed.
}
\description{
Creates and returns the plot of the maraca data.
}
\examples{
data(hce_scenario_a)
hce_test <- maraca(
  data = hce_scenario_a,
  step_outcomes = c("Outcome I", "Outcome II", "Outcome III", "Outcome IV"),
  last_outcome = "Continuous outcome",
  fixed_followup_days = 3 * 365,
  column_names = c(outcome = "GROUP", arm = "TRTP", value = "AVAL0"),
  arm_levels = c(active = "Active", control = "Control"),
  compute_win_odds = TRUE
)
plot <- plot_maraca(hce_test)
}
