% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simcam.R
\name{plotDiscriminationPower.simcam}
\alias{plotDiscriminationPower.simcam}
\title{Discrimination power plot for SIMCAM model}
\usage{
\method{plotDiscriminationPower}{simcam}(
  obj,
  nc = c(1, 2),
  type = "h",
  main = paste0("Discrimination power: ", obj$classnames[nc[1]], " vs. ",
    obj$classname[nc[2]]),
  xlab = attr(obj$dispower, "xaxis.name"),
  ylab = "",
  ...
)
}
\arguments{
\item{obj}{a SIMCAM model (object of class \code{simcam})}

\item{nc}{vector with two values - classes (SIMCA models) to show the plot for}

\item{type}{type of the plot}

\item{main}{main plot title}

\item{xlab}{label for x axis}

\item{ylab}{label for y axis}

\item{...}{other plot parameters (see \code{mdaplotg} for details)}
}
\description{
Shows a plot with discrimination power of predictors for a pair of SIMCA models
}
\details{
Discrimination power shows an ability of variables to separate classes. The power is computed
similar to model distance, using variance of residuals. However in this case instead of sum the
variance across all variables, we take the ratio separately for individual variables.

Discrimination power equal or above 3 is considered as high.
}
