% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fns.R
\name{constrained.unpenalized}
\alias{constrained.unpenalized}
\title{Estimate hard constraint model parameters using cyclical coordinate descent.}
\usage{
constrained.unpenalized(
  Y,
  M,
  A,
  C = NULL,
  T.hat.external,
  err.tol.out = 1e-08,
  err.tol.med = 1e-08,
  max.itr = 10000
)
}
\arguments{
\item{Y}{A (n x 1) continuous outcome vector.}

\item{M}{A (n x p_m) matrix of mediators.}

\item{A}{A (n x 1) vector of exposures.}

\item{C}{A (n x p_c) matrix of confounders and adjustment covariates. If there are no confounders or adjustment covariates set C = NULL.}

\item{T.hat.external}{External estimate of the total effect.}

\item{err.tol.out}{Termination condition for cyclical coordinate descent algorithm with respect to the outcome model parameters.}

\item{err.tol.med}{Termination condition for cyclical coordinate descent algorithm with respect to the mediator model parameters.}

\item{max.itr}{Maximum number of iterations for cyclical coordinate descent algorithm.}
}
\value{
A list containing point estimates of the hard constraint model parameters and an indicator of whether the algorithm converges.
}
\description{
Estimate hard constraint model parameters using cyclical coordinate descent.
}
