% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_function.R
\name{plot_messi}
\alias{plot_messi}
\title{Forestplot to Summarize Estimation and Inference on alpha_a and beta_m.}
\usage{
plot_messi(n, alpha.a.hat, beta.m.hat, labels, asym.var.mat)
}
\arguments{
\item{n}{Sample size of the analysis}

\item{alpha.a.hat}{Estimate of alpha_a, a (p_m x 1) vector.}

\item{beta.m.hat}{Estimate of beta_m, a (p_m x 1) vector.}

\item{labels}{A (p_m x 1) vector of mediator names. Make sure that the labels are in the same order as the mediators appear in the design matrix.}

\item{asym.var.mat}{Joint asymptotic variance-covariance matrix of alpha_a and beta_m, a (2p_m x 2p_m) matrix.}
}
\value{
Data frames and forestplots summarizing alpha_a and beta_m estimation.
}
\description{
Forestplot to Summarize Estimation and Inference on alpha_a and beta_m.
}
\examples{
data(Med)

Y = Med$Y
M = Med$M
A = Med$A
C = Med$C
T.hat.external = Med$T.hat.external
var.T.hat.external = Med$var.T.hat.external

test <- messi(Y = Y, M = M, A = A, C = C, method = 'Unconstrained', T.hat.external = T.hat.external,
              var.T.hat.external = var.T.hat.external, s2.fixed = NULL)

n = Med$n
p = Med$p

plot_messi(n = n, alpha.a.hat = test$alpha.a.hat, beta.m.hat = test$beta.m.hat, 
           labels = paste0("M",1:p), asym.var.mat = test$asym.var.mat)


}
