% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BenchmarkResult.R
\name{uhashes}
\alias{uhashes}
\alias{uhash}
\title{Obtain specific uhashes from a \link{BenchmarkResult}}
\usage{
uhashes(bmr, learner_ids = NULL, task_ids = NULL, resampling_ids = NULL)

uhash(bmr, learner_id = NULL, task_id = NULL, resampling_id = NULL)
}
\arguments{
\item{bmr}{(\code{BenchmarkResult})\cr
Benchmark result.}

\item{learner_ids}{(\code{character()} | \code{NULL})\cr
Learner IDs.}

\item{task_ids}{(\code{character()} | \code{NULL})\cr
Task IDs.}

\item{resampling_ids}{(\code{character()} | \code{NULL})\cr
Resampling IDs.}

\item{learner_id}{(\code{character(1)} | \code{NULL})\cr
Learner ID.}

\item{task_id}{(\code{character(1)} | \code{NULL})\cr
Task ID.}

\item{resampling_id}{(\code{character(1)} | \code{NULL})\cr
Resampling ID.}
}
\description{
In a \code{\link{BenchmarkResult}}, each \link{ResampleResult} is \emph{u}niquely identified by a \emph{hash} (\emph{uhash}).
Operations that select specific \link{ResampleResult}s from a \link{BenchmarkResult} operate using
these hashes.
This function allows to obtain uhashes for specific learners, tasks, and resamplings.

If you want more control, you can also directly obtain the uhash table from the \code{\link{BenchmarkResult}}
via the field \verb{$uhash_table}.
}
\examples{
design = benchmark_grid(
  tsks(c("sonar", "iris")),
  lrns(c("classif.debug", "classif.featureless", "classif.rpart")),
  rsmp("holdout")
)
bmr = benchmark(design)
bmr
bmr$uhashes
uhash(bmr, learner_id = "classif.debug", task_id = "sonar", resampling_id = "holdout")
uhashes(bmr, learner_ids = c("classif.debug", "classif.featureless"))
}
