% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataBackendRaster.R, R/DataBackendVector.R
\name{as_data_backend.stars}
\alias{as_data_backend.stars}
\alias{as_data_backend.SpatRaster}
\alias{as_data_backend.RasterBrick}
\alias{as_data_backend.RasterStack}
\alias{as_data_backend.sf}
\title{Coerce to spatial DataBackend}
\usage{
\method{as_data_backend}{stars}(data, primary_key = NULL, ...)

\method{as_data_backend}{SpatRaster}(data, primary_key = NULL, ...)

\method{as_data_backend}{RasterBrick}(data, primary_key = NULL, ...)

\method{as_data_backend}{RasterStack}(data, primary_key = NULL, ...)

\method{as_data_backend}{sf}(data, primary_key = NULL, keep_rownames = FALSE, ...)
}
\arguments{
\item{data}{(\link[terra:SpatRaster-class]{terra::SpatRaster})\cr
The input \link[terra:SpatRaster-class]{terra::SpatRaster}.}

\item{primary_key}{(\code{character(1)} | \code{integer()})\cr
Name of the primary key column, or integer vector of row ids.}

\item{...}{(\code{any})\cr
Not used.}

\item{keep_rownames}{(\code{logical(1)} | \code{character(1)})\cr
If \code{TRUE} or a single string, keeps the row names of \code{data} as a new column.
The column is named like the provided string, defaulting to \code{"..rownames"} for \code{keep_rownames == TRUE}.
Note that the created column will be used as a regular feature by the task unless you manually change the column role.
Also see \code{\link[data.table:as.data.table]{data.table::as.data.table()}}.}
}
\value{
\link{DataBackend}.
}
\description{
Wraps a \link{DataBackend} around spatial objects.
Currently these S3 methods are only alternative ways for writing \code{DataBackendRaster$new()}.
They do not support coercing from other backends yet.
}
