% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likRatePhylo.R
\name{likRatePhylo}
\alias{likRatePhylo}
\title{Log-likelihood rate estimation for traits and phylogenies}
\usage{
likRatePhylo(
  rateData,
  rate = NULL,
  common.mean = FALSE,
  lambda.est = TRUE,
  lambda = 1,
  meserr = FALSE,
  sigmaScale = NULL
)
}
\arguments{
\item{rateData}{an object of class \code{rateData}}

\item{rate}{a vector of relative rate parameters. The length of the vector is equal to the number of rates being estimated. If \code{rate=NULL} then rates are equal.}

\item{common.mean}{a logical specififying whether each rate category should have its own mean (\code{common.mean=FALSE}) or all categories should have the same mean (\code{common.mean=FALSE}). See Thomas et al. (2009) for a discussion on the impact of assumptions about mean on rate estimates.#'}

\item{lambda.est}{Logical. Fit Pagel's lambda.}

\item{lambda}{Logical. Numeric value for lambda from 0-1.}

\item{meserr}{Logical. Logical. Include measurement error.}

\item{sigmaScale}{Logical. Scalar for measurement error relative to tree.}
}
\value{
ll log-likelihood of the model

mu phylogenetically corrected mean(s)

s2 Brownian variance
}
\description{
This function calculates the log-likelihood, phylogenetic mean, and Brownian variance for a trait and a phylogeny transformed according to variation in relative rates.
}
\note{
The means are output as treatment contrasts.
}
\examples{
data(anolis.tree)
data(anolis.data)

## Convert data to class rateData with a rateMatrix object as input
anolis.rateMatrix <- as.rateMatrix(phy=anolis.tree, x="geo_ecomorph", data=anolis.data)

anolis.rateData <- as.rateData(y="Female_SVL", x="geo_ecomorph", 
rateMatrix = anolis.rateMatrix, phy=NULL, data=anolis.data, log.y=TRUE)

## Calculate phylogenetic mean, variance, log likelihood for a model where the first 

# mean only
phyloMean(rateData=anolis.rateData, rate = c(1,2,0.1,1), common.mean = FALSE)

# variance only
phyloVar(rateData=anolis.rateData, rate = c(1,2,0.1,1), common.mean = FALSE) 

# mean, variance and log-likelihood
likRatePhylo(rateData=anolis.rateData, rate = c(1,2,0.1,1), common.mean = FALSE) 
}
\references{
Thomas GH, Freckleton RP, & Szekely T. 2006. Comparative analyses of the influence of developmental mode on phenotypic diversification rates in shorebirds. Proceedings of the Royal Society B 273, 1619-1624.

Thomas GH, Meiri S, & Phillimore AB. 2009. Body size diversification in Anolis: novel environments and island effects. Evolution 63, 2017-2030.
}
\author{
Gavin Thomas, Rob Freckleton
}
