% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{calculate_ave_cross_power1}
\alias{calculate_ave_cross_power1}
\title{Calculate average cross power distribution using a splicing table}
\usage{
calculate_ave_cross_power1(
  jv,
  splicing_df,
  splice_name,
  num_segment_samples,
  columns,
  show_plot = TRUE
)
}
\arguments{
\item{jv}{\code{JoinedView} object.}

\item{splicing_df}{\code{Splice} object.}

\item{splice_name}{Name to give randomly spliced segments.}

\item{num_segment_samples}{number of segments to randomly sample.}

\item{columns}{name of data columns on which to calculate average cross power.}

\item{show_plot}{show the plot? (Default is TRUE).}
}
\value{
a data frame: containing average cross power on the spliced JoinedView.
}
\description{
Calculate average cross power distribution using a splicing table
}
\examples{
r <- get_sample_recording()
fv_list <- get_filtered_views(r, data_points = 'Nose', n = 41, p = 3)
jv <- get_joined_view(fv_list)
splicing_df <- splice_time(list(a = c(0, 5), b = c(10, 15)))
output_dfr <- calculate_ave_cross_power1(jv, splicing_df, 'Splice', 10,
  c('Nose_x_Central_Tabla', 'Nose_y_Central_Tabla'))
}
\seealso{
Other statistical and analysis functions: 
\code{\link{apply_column_spliceview}()},
\code{\link{apply_segment_spliceview}()},
\code{\link{ave_cross_power_over_splices}()},
\code{\link{ave_cross_power_spliceview}()},
\code{\link{ave_power_over_splices}()},
\code{\link{ave_power_spliceview}()},
\code{\link{calculate_ave_power1}()},
\code{\link{compare_ave_cross_power1}()},
\code{\link{compare_ave_power1}()},
\code{\link{compare_avg_cross_power2}()},
\code{\link{compare_avg_power2}()},
\code{\link{difference_onsets}()},
\code{\link{pull_segment_spliceview}()},
\code{\link{sample_gap_splice}()},
\code{\link{sample_offset_splice}()},
\code{\link{summary_onsets}()},
\code{\link{visualise_sample_splices}()}
}
\concept{statistical and analysis functions}
