% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msdFilter.R
\name{msdFilter}
\alias{msdFilter}
\title{msdFilter -- A triangular Filter for smoothing data}
\usage{
msdFilter(x, window = 31, quantity = 2)
}
\arguments{
\item{x}{TimeSeries or numeric vector}

\item{window}{Size of Filter [Default = 31]}

\item{quantity}{Number of passes to apply filter [Default = 2]}
}
\value{
Vector of Yearly data
}
\description{
The filter will take a weighted average of a specified number of points
around the point of interest to create a smoother time series. For
example, if the size of the filter is set to 31, the filter will take the
15 points before and after the point of interest (for a total of 31 points),
and calculate a weighted average based on how far away the points are from
the point of interest.
}
\examples{

dates <- seq(from = as.Date("1981-01-01"), to = as.Date("1982-12-31"), by = "day")
ts <- xts::xts(runif(length(dates), 0, 50),dates)
filteredData <- msdrought::msdFilter(ts, window = 31, quantity = 2)

}
