/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.solver;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import ru.itmo.ctlab.virgo.SolverException;
import ru.itmo.ctlab.virgo.TimeLimit;
import ru.itmo.ctlab.virgo.sgmwcs.Signals;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Dijkstra;
import ru.itmo.ctlab.virgo.sgmwcs.solver.RootedSolver;

public class Worker
implements Runnable {
    private final Signals signals;
    private final Graph graph;
    private final RootedSolver solver;
    private final Node root;
    private List<Unit> result = new ArrayList<Unit>();
    private boolean isSolvedToOptimality;
    private long startTime;

    public Worker(Graph graph, Node root, Signals signals, RootedSolver solver, long time) {
        this.solver = solver;
        this.graph = graph;
        this.signals = signals;
        this.root = root;
        this.isSolvedToOptimality = false;
        this.startTime = time;
    }

    @Override
    public void run() {
        Set<Node> vertexSet = this.graph.vertexSet();
        if (vertexSet.size() <= 1) {
            this.result = vertexSet.stream().filter(n -> this.signals.weight((Unit)n) >= 0.0).collect(Collectors.toList());
            return;
        }
        Node treeRoot = Optional.ofNullable(this.root).orElse(vertexSet.stream().max(Comparator.comparing(this.signals::weight)).get());
        List<Unit> sol = new ArrayList<Unit>(new Dijkstra(this.graph, this.signals).greedyHeuristic(treeRoot, new ArrayList<Unit>()));
        sol.add(treeRoot);
        sol = Unit.extractAbsorbed(sol).stream().filter(this.graph::containsUnit).collect(Collectors.toList());
        if (this.solver != null) {
            try {
                double tl = this.solver.getTimeLimit().getRemainingTime() - (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
                if (tl <= 0.0) {
                    this.isSolvedToOptimality = false;
                    return;
                }
                this.solver.setRoot(this.root);
                this.solver.setTimeLimit(new TimeLimit(Math.max(tl, 0.0)));
                double tlb = this.signals.sum(sol);
                double plb = this.solver.getLB().get();
                if (tlb >= plb) {
                    System.out.println("heuristic found lb " + tlb);
                    this.solver.setInitialSolution(sol);
                    this.solver.getLB().compareAndSet(plb, tlb);
                }
                sol = this.solver.solve(this.graph, this.signals);
                this.isSolvedToOptimality = this.solver.isSolvedToOptimality();
            }
            catch (SolverException e) {
                this.result = null;
                return;
            }
        }
        if (this.signals.sum(sol) > this.signals.sum(this.result)) {
            this.result = sol;
        }
    }

    public List<Unit> getResult() {
        return this.result;
    }

    public boolean isSolvedToOptimality() {
        return this.isSolvedToOptimality;
    }
}

