% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_mfcm.R
\name{run_mfcm}
\alias{run_mfcm}
\title{Run function Cox models for data with multiple samples per subject}
\usage{
run_mfcm(
  mxFDAobject,
  model_name,
  formula,
  event = "event",
  metric = "uni k",
  r = "r",
  value = "fundiff",
  afcm = FALSE,
  filter_cols = NULL,
  pve = 0.99,
  ...,
  knots = NULL
)
}
\arguments{
\item{mxFDAobject}{Dataframe of spatial summary functions from multiplex imaging data, in long format. Can be estimated using the function \code{extract_summary_functions} or provided separately.}

\item{model_name}{character string to give the fit model in the functional cox slot}

\item{formula}{Formula to be fed to mgcv in the form of survival_time ~ x1 + x2. Does not contain functional predictor. Character valued. Data must contain censoring variable called "event".}

\item{event}{character string for the column in Metadata that contains 1/0 for the survival event}

\item{metric}{name of calculated spatial metric to use}

\item{r}{Character string, the name of the variable that identifies the function domain (usually a radius for spatial summary functions). Default is "r".}

\item{value}{Character string, the name of the variable that identifies the spatial summary function values. Default is "fundiff".}

\item{afcm}{If TRUE, runs additive functional Cox model. If FALSE, runs linear functional cox model. Defaults to linear functional cox model.}

\item{filter_cols}{a named vector of factors to filter summary functions to in \code{c(Derived_Column = "Level_to_Filter")} format}

\item{pve}{Proportion of variance explained by multilevel functional principal components analysis in mfpca step}

\item{...}{Optional other arguments to be passed to \code{fpca.face}}

\item{knots}{Number of knots for defining spline basis.}
}
\value{
A \code{list} which is a linear or additive functional Cox model fit. See \code{mgcv::gam} for more details.
}
\description{
Fit a functional Cox regression model when there are multiple functions per subject, which arise from multiple samples per subject.
It is not necessary for all subjects to have the same number of samples.The function first performs a multilevel functional principal components
analysis (MFPCA) decomposition to the spatial summary function. Then, the average curve for each subject is used in a functional Cox model (FCM).
Variation around each subject's mean is captured by calculating the standard deviation of the level 2 scores from MFPCA, then including this as
a scalar variable in the FCM called "level2_score_sd".
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
#load ovarian mxFDA object
data('lung_FDA')

# run the lfcm model
lung_FDA = run_mfcm(lung_FDA, model_name = "fit_mlfcm",
                      formula = survival_days ~ age,
                      event = "survival_status",
                      metric = "uni g", r = "r", value = "fundiff",
                      pve = 0.99,
                      afcm = FALSE)
}
\author{
Julia Wrobel \email{julia.wrobel@emory.edu}

Alex Soupir \email{alex.soupir@moffitt.org}
}
