% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rklib.r
\name{rk.where}
\alias{rk.where}
\title{Process Where Clause}
\usage{
rk.where(where = NULL, mode = "@", fields = NULL)
}
\arguments{
\item{where}{clause following simplified sql syntax.}

\item{mode}{specifies the parsing logic. The default value '@' returns the where clause in perfmeter format. The '=' value returns the where clause in IOD format. The '~' value returns the where clause in Jira format. The '' (empty string) value returns a where clause used with a sql statement. If a dataframe name is passed, the function returns the where clause for use with a dataframe.}

\item{fields}{fields to be filtered.}
}
\value{
The function returns the processed where clause.
}
\description{
The function parses the where clause and returns the modified string as per the specified mode.
The where clause supported format is represented by the following BNF:
\preformatted{
<where.cond> := <where.and> [ LOGICAL.OR <where.cond> ]
<where.and> := <where.not> [ LOGICAL.AND <where.and> ]
<where.not> := [ LOGICAL.NOT ] <where.clause>
<where.clause> := LEFT.PAREN <where.cond> RIGHT.PAREN | <where.expr>
<where.expr> := ( IDENTIFIER | QUOTE.STR ) ( [ LOGICAL.NOT ] ( OPERATOR.IN <value.list> | OPERATOR.LIKE <value.const> ) | OPERATOR.IS [ LOGICAL.NOT ] VALUE.NULL | <logic.cond> )
<logic.cond> := ( EQUAL.TO | NOT.EQUAL | LESS.THAN | GREATER.THAN | LESS.EQUAL | GREATER.EQUAL ) <value.const>
<value.list> := LEFT.PAREN <value.const> ( DELIMIT.COMMA <value.const> ) * RIGHT.PAREN
<value.const> := | QUOTE.STR | NUMBER
}
}
