% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asthma_01.R
\name{asthma_01}
\alias{asthma_01}
\title{Asthma-01 Calculation}
\usage{
asthma_01(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  medications_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  esituation_11_col,
  esituation_12_col,
  emedications_03_col,
  ...
)
}
\arguments{
\item{df}{A data.frame or tibble containing EMS data. Default is \code{NULL}.}

\item{patient_scene_table}{A data.frame or tibble containing at least
ePatient and eScene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data.frame or tibble containing at least the
eResponse fields needed for this measure's calculations. Default is \code{NULL}.}

\item{situation_table}{A data.frame or tibble containing at least the
eSituation fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{medications_table}{A data.frame or tibble containing at least the
eMedications fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{erecord_01_col}{The column representing the EMS record unique
identifier. Default is \code{NULL}.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column representing the patient's numeric age agnostic
of unit.}

\item{epatient_16_col}{Column representing the patient's age unit ("Years",
"Months", "Days", "Hours", or "Minute").}

\item{eresponse_05_col}{Column that contains eResponse.05.}

\item{esituation_11_col}{Column that contains eSituation.11.}

\item{esituation_12_col}{Column that contains all eSituation.12 values as a
single comma-separated list.}

\item{emedications_03_col}{Column that contains all eMedications.03 values as
a single comma-separated list.}

\item{...}{optional additional arguments to pass onto \code{dplyr::summarize}.}
}
\value{
A data.frame summarizing results for three population groups (All,
Adults, and Peds) with the following columns:
\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (All,
Adults, or Peds).
\code{numerator}: Count of incidents where beta-agonist
medications were administered.
\code{denominator}: Total count of incidents.
\code{prop}: Proportion of incidents involving beta-agonist medications.
\code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
}
\description{
Calculates the NEMSQA Asthma-01 measure.

Calculates key statistics related to asthma-related incidents in an EMS
dataset, specifically focusing on cases where 911 was called for respiratory
distress, and certain medications were administered. This function segments
the data by age into adult and pediatric populations, computing the
proportion of cases that received beta-agonist treatment.
}
\examples{

# Synthetic test data
test_data <- tibble::tibble(
  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  epatient_15 = c(34, 5, 45, 2, 60),  # Ages
  epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
  eresponse_05 = rep(2205001, 5),
  esituation_11 = c("Respiratory Distress", "Respiratory Distress",
  "Chest Pain", "Respiratory Distress", "Respiratory Distress"),
  esituation_12 = c("Asthma", "Asthma", "Other condition", "Asthma", "Asthma"),
  emedications_03 = c("Albuterol", "Albuterol", "Epinephrine", "None",
  "Albuterol")
)

# Run the function
asthma_01(
  df = test_data,
  erecord_01_col = erecord_01,
  epatient_15_col = epatient_15,
  epatient_16_col = epatient_16,
  eresponse_05_col = eresponse_05,
  esituation_11_col = esituation_11,
  esituation_12_col = esituation_12,
  emedications_03_col = emedications_03
)

}
\author{
Nicolas Foss, Ed.D., MS
}
