% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seizure_02.R
\name{seizure_02}
\alias{seizure_02}
\title{Seizure-02 Calculation}
\usage{
seizure_02(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  medications_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  esituation_11_col,
  esituation_12_col,
  emedications_03_col,
  ...
)
}
\arguments{
\item{df}{A data frame where each row is an observation, containing all
necessary columns for analysis.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{situation_table}{A data.frame or tibble containing only the esituation
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{medications_table}{A data.frame or tibble containing only the
emedications fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{erecord_01_col}{The column containing unique record identifiers for
each encounter.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column name for patient age in numeric form.}

\item{epatient_16_col}{Column name for age unit (e.g., \code{"Years"} or
\code{"Months"}).}

\item{eresponse_05_col}{Column name for response codes; "911" call codes are
filtered.}

\item{esituation_11_col}{Column name for primary impressions.}

\item{esituation_12_col}{Column name for secondary impressions.}

\item{emedications_03_col}{Column name for medications administered; ideally
a list column or string with comma-separated values.}

\item{...}{Additional arguments passed to \code{dplyr::summarize}.}
}
\value{
A tibble summarizing results for three population groups (All,
Adults, and Peds) with the following columns:

\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (All,
Adults, or Peds).
\code{numerator}: Count of incidents where beta-agonist
medications were administered.
\code{denominator}: Total count of incidents.
\code{prop}: Proportion of incidents involving beta-agonist medications.
\code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
}
\description{
Calculates the NEMSQA Seizure-02 Measure.

Calculates age-based seizure metrics for a dataset. This function filters
data for patients based on incident information, diagnoses, and administered
medications to assess adherence to Seizure-02 metrics.
}
\examples{

# Synthetic test data
  test_data <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    epatient_15 = c(34, 5, 45, 2, 60),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
    eresponse_05 = rep(2205001, 5),
    esituation_11 = rep("G40", 5),
    esituation_12 = rep("r56", 5),
    emedications_03 = rep(3322, 5)
  )

  # Run the function
  seizure_02(
    df = test_data,
    erecord_01_col = erecord_01,
    epatient_15_col = epatient_15,
    epatient_16_col = epatient_16,
    eresponse_05_col = eresponse_05,
    esituation_11_col = esituation_11,
    esituation_12_col = esituation_12,
    emedications_03_col = emedications_03,
  )

}
\author{
Nicolas Foss, Ed.D., MS
}
