% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nemsqar_disposition_table.R
\docType{data}
\name{nemsqar_disposition_table}
\alias{nemsqar_disposition_table}
\title{Synthetic Test Data for eDisposition Fields in National EMS Information System}
\format{
A data frame with 10,000 rows and 13 variables:
\describe{
\item{Incident Patient Care Report Number - PCR (eRecord.01)}{Unique identifier for the incident report (character).}
\item{Incident Date}{Date of the incident (Date).}
\item{Disposition Position Of Patient During Transport List (eDisposition.14)}{Position of the patient during transport (character).}
\item{Disposition Additional Transport Mode Descriptor (eDisposition.18)}{Additional transport mode details (character).}
\item{Disposition Additional Transport Mode Descriptor List (eDisposition.18)}{List of additional transport mode descriptors (character).}
\item{Hospital Capability (3.4=itDisposition.105/3.5=eDisposition.23)}{Primary hospital capability associated with the incident (character).}
\item{Hospital Capability List (3.4=itDisposition.105/3.5=eDisposition.23)}{List of hospital capabilities at the destination facility (character).}
\item{Disposition Team Pre Arrival Alert (eDisposition.24)}{Indicates whether a pre-arrival alert was triggered for the team (character).}
\item{Disposition Destination Team Pre-arrival Alert Activation (eDisposition.24)}{Indicates the specific type of pre-arrival alert activated (character).}
\item{Destination Trauma General Team Pre-arrival Activation (eDisposition.24)}{Indicates whether a general trauma team was activated pre-arrival (logical).}
\item{Patient Evaluation/Care (3.4=itDisposition.100/3.5=eDisposition.28)}{Evaluation or care provided to the patient (character).}
\item{Transport Disposition (3.4=itDisposition.102/3.5=eDisposition.30)}{Final transport disposition of the patient (character).}
\item{Disposition Incident Patient Disposition With Code (3.4=eDisposition.12/3.5=itDisposition.112)}{Final disposition of the patient, including standardized codes (character).}
}
}
\usage{
data(nemsqar_disposition_table)
}
\description{
This dataset provides completely synthetic test data for evaluating disposition-related
functions in the \code{nemsqar} package. It includes key variables related to patient
disposition, transport mode, hospital capabilities, and team pre-arrival alerts.
The dataset is intended to assist users in testing the expected input structure
for disposition-related measures.
}
\details{
Users are encouraged to test these functions with this dataset, but results
should not be interpreted as meaningful. Some outputs may be nonsensical,
which is expected since this data is only intended to demonstrate the
expected structure of input data.
}
\examples{
data(nemsqar_disposition_table)
head(nemsqar_disposition_table)

}
\keyword{datasets}
