% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/de.R
\name{differential_evolution}
\alias{differential_evolution}
\title{Implementation of Differential Evolution metaheuristic algorithm.}
\usage{
differential_evolution(
  D = 10,
  NP = 10,
  F = 0.5,
  CR = 0.9,
  nfes = 1000,
  features,
  data
)
}
\arguments{
\item{D}{Dimension of the problem (default: 10).}

\item{NP}{Population size (default: 10).}

\item{F}{The differential weight, controlling the amplification of the difference vector (default: 0.5).}

\item{CR}{The crossover probability, determining the probability of a component being replaced (default: 0.9).}

\item{nfes}{The maximum number of function evaluations (default: 1000).}

\item{features}{A list containing information about features, including type and bounds.}

\item{data}{A data frame representing instances in the dataset.}
}
\value{
A list containing the best solution, its fitness value, and the number of function evaluations and list of identified association rules.
}
\description{
This function uses Differential Evolution, a stochastic population-based optimization algorithm,
to find the optimal numerical association rule.
}
