% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpLin.R
\name{interpLin}
\alias{interpLin}
\title{Linear interpolation function}
\usage{
interpLin(z, x, y)
}
\arguments{
\item{z}{value where the interpolation take place}

\item{x}{numeric vector giving the coordinates of the points to be interpolated.}

\item{y}{numeric vector giving the coordinates of the points to be interpolated.}
}
\value{
interpolated value
}
\description{
A \code{nimbleFunction} emulating BUGS/JAGS's interp.lin.
}
\examples{
data(intcal20)
interpLin(4500,intcal20$CalBP,intcal20$C14Age)
# equivalent to:
approx(x=intcal20$CalBP,y=intcal20$C14Age,xout=4500)$y
}
